/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.mojos.AbstractVertxMojo;
import io.reactiverse.vertx.maven.plugin.mojos.MojoSpy;
import io.reactiverse.vertx.maven.plugin.utils.WebJars;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class InitializeMojo
extends AbstractVertxMojo {
    @Parameter
    private File webRoot;
    @Parameter(defaultValue="false")
    private boolean unpackWebJar;
    @Parameter(defaultValue="true")
    private boolean stripWebJarVersion;
    @Parameter(defaultValue="true")
    private boolean stripJavaScriptDependencyVersion;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:initialize skipped by configuration");
            return;
        }
        if (this.webRoot == null) {
            this.webRoot = new File(this.project.getBuild().getOutputDirectory(), "webroot");
        }
        LinkedHashSet<Artifact> dependencies = new LinkedHashSet<Artifact>();
        dependencies.addAll(this.project.getDependencyArtifacts().stream().filter(artifact -> !"test".equalsIgnoreCase(artifact.getScope())).collect(Collectors.toList()));
        dependencies.addAll(this.project.getArtifacts());
        this.copyJSDependencies(dependencies);
        if (this.unpackWebJar) {
            this.unpackWebjars(dependencies);
        }
        MavenExecutionRequest request = this.mavenSession.getRequest();
        MojoSpy.init(request);
    }

    private void unpackWebjars(Set<Artifact> dependencies) throws MojoExecutionException {
        for (Artifact artifact : dependencies) {
            File file = this.getArtifactFile(artifact).filter(File::isFile).orElseThrow(() -> new MojoExecutionException("Unable to copy WebJar dependency, " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " has not been resolved"));
            if (!artifact.getType().equalsIgnoreCase("jar")) continue;
            this.unpackWebJar(artifact, file);
        }
    }

    private void unpackWebJar(Artifact artifact, File file) throws MojoExecutionException {
        if (WebJars.isWebJar(this.getLog(), file)) {
            try {
                WebJars.extract(this, file, this.createWebRootDirIfNeeded(), this.stripWebJarVersion);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to unpack '" + artifact.toString() + "'", (Exception)e);
            }
        }
    }

    private File createWebRootDirIfNeeded() {
        if (!this.webRoot.isDirectory()) {
            boolean created = this.webRoot.mkdirs();
            if (created) {
                this.getLog().debug((CharSequence)("Webroot directory created: " + this.webRoot.getAbsolutePath()));
            } else {
                this.getLog().error((CharSequence)("Unable to create directory: " + this.webRoot.getAbsolutePath()));
            }
        }
        return this.webRoot;
    }

    private void copyJSDependencies(Set<Artifact> dependencies) throws MojoExecutionException {
        for (Artifact artifact : dependencies) {
            if (!artifact.getType().equalsIgnoreCase("js")) continue;
            File file = this.getArtifactFile(artifact).filter(File::isFile).orElseThrow(() -> new MojoExecutionException("Unable to copy JS dependencies, " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " has not been resolved"));
            this.copyJavascriptDependency(artifact, file);
        }
    }

    private void copyJavascriptDependency(Artifact artifact, File file) throws MojoExecutionException {
        try {
            if (this.stripJavaScriptDependencyVersion) {
                String name = artifact.getArtifactId();
                if (artifact.getClassifier() != null) {
                    name = name + "-" + artifact.getClassifier();
                }
                name = name + ".js";
                File output = new File(this.createWebRootDirIfNeeded(), name);
                FileUtils.copyFile((File)file, (File)output);
            } else {
                FileUtils.copyFileToDirectory((File)file, (File)this.createWebRootDirIfNeeded());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy '" + artifact.toString() + "'", (Exception)e);
        }
    }
}

