/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.mojos.AbstractRunMojo;
import io.reactiverse.vertx.maven.plugin.mojos.PackageMojo;
import io.reactiverse.vertx.maven.plugin.utils.MavenExecutionUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="start", threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class StartMojo
extends AbstractRunMojo {
    @Parameter(alias="mode", property="vertx.start.mode", defaultValue="jar")
    protected String runMode;
    @Parameter(alias="appId", property="vertx.app.id")
    protected String appId;
    @Parameter(name="classifier")
    protected String classifier;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:start skipped by configuration");
            return;
        }
        this.vertxCommand = "start";
        String applicationId = this.getAppId();
        this.options = this.scanAndLoad("options", this.options);
        this.config = this.scanAndLoad("application", this.config);
        ArrayList<String> argsList = new ArrayList<String>();
        this.writePidFile(applicationId);
        boolean jarMode = "jar".equals(this.runMode);
        if (jarMode) {
            String name = PackageMojo.computeOutputName(this.computeArchive(), this.project, this.classifier);
            File fatjar = new File(this.project.getBuild().getDirectory(), name);
            this.buildJarIfRequired(fatjar);
            if (fatjar.isFile() && this.isVertxLauncher(this.launcher)) {
                argsList.add("-jar");
                argsList.add(fatjar.getAbsolutePath());
            } else {
                if (!fatjar.isFile() || this.isVertxLauncher(this.launcher)) throw new MojoFailureException("Unable to find vertx application jar --> " + fatjar.getAbsolutePath());
                argsList.add("-cp");
                argsList.add(SystemUtils.IS_OS_WINDOWS ? '\"' + fatjar.getAbsolutePath() + '\"' : fatjar.getAbsolutePath());
                argsList.add("io.vertx.core.Launcher");
            }
        } else {
            this.addClasspath(argsList);
            if (this.isVertxLauncher(this.launcher)) {
                argsList.add(this.launcher);
            } else {
                argsList.add("io.vertx.core.Launcher");
            }
        }
        argsList.add(this.vertxCommand);
        if (!jarMode) {
            argsList.add(this.verticle);
        }
        this.appendOptionsIfRequired(argsList);
        this.appendConfigIfRequired(argsList);
        this.appendLauncherIfRequired(argsList);
        argsList.add("-id");
        argsList.add(applicationId);
        this.appendSysProperties(argsList);
        this.run(argsList);
    }

    private void writePidFile(String vertxProcId) throws MojoExecutionException {
        try {
            File pid = new File(this.workDirectory, "vertx-start-process.id");
            FileUtils.write((File)pid, (CharSequence)vertxProcId, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write process file to directory :" + this.workDirectory.toString(), (Exception)e);
        }
    }

    private void buildJarIfRequired(File fatjar) {
        if (!fatjar.isFile()) {
            this.getLog().warn((CharSequence)"Unable to find the Vert.x application jar, triggering the build");
            MavenExecutionUtils.execute("package", this.project, this.mavenSession, this.lifecycleExecutor, this.container);
        }
    }

    private void appendSysProperties(List<String> argsList) {
        if (this.jvmArgs != null && !this.jvmArgs.isEmpty()) {
            String javaOpts = this.jvmArgs.stream().collect(Collectors.joining(" "));
            String argJavaOpts = "--java-opts=" + javaOpts;
            argsList.add(argJavaOpts);
        }
    }

    private void appendLauncherIfRequired(List<String> argsList) throws MojoExecutionException {
        if (this.launcher != null && !this.isVertxLauncher(this.launcher)) {
            argsList.add("--launcher-class");
            argsList.add(this.launcher);
        }
    }

    private void appendOptionsIfRequired(List<String> argsList) {
        if (this.options != null && this.options.exists() && this.options.isFile()) {
            this.getLog().info((CharSequence)("Using options from file: " + this.options.toString()));
            argsList.add("-options");
            argsList.add(this.options.toString());
        }
    }

    private void appendConfigIfRequired(List<String> argsList) {
        if (this.config != null && this.config.exists() && this.config.isFile()) {
            this.getLog().info((CharSequence)("Using configuration from file: " + this.config.toString()));
            argsList.add("-conf");
            argsList.add(this.config.toString());
        }
    }

    private String getAppId() {
        if (this.appId == null) {
            UUID uuid = UUID.randomUUID();
            this.appId = uuid.toString();
        }
        return this.appId;
    }
}

