/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.components;

import io.reactiverse.vertx.maven.plugin.mojos.Archive;
import io.reactiverse.vertx.maven.plugin.mojos.DependencySet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;

public class ServiceUtils {
    private ServiceUtils() {
    }

    public static Archive getDefaultFatJar() {
        Archive archive = new Archive();
        archive.addDependencySet(DependencySet.ALL);
        archive.setIncludeClasses(true);
        archive.addFileCombinationPattern("META-INF/services/*");
        archive.addFileCombinationPattern("META-INF/spring.*");
        archive.addFileCombinationPattern("META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat");
        return archive;
    }

    public static Set<Artifact> filterArtifacts(Set<Artifact> artifacts, List<String> includes, List<String> excludes, boolean actTransitively, Log logger, ArtifactFilter ... additionalFilters) {
        AndArtifactFilter filter = new AndArtifactFilter();
        if (additionalFilters != null && additionalFilters.length > 0) {
            for (ArtifactFilter additionalFilter : additionalFilters) {
                if (additionalFilter == null) continue;
                filter.add(additionalFilter);
            }
        }
        if (!includes.isEmpty()) {
            PatternIncludesArtifactFilter includeFilter = new PatternIncludesArtifactFilter(includes, actTransitively);
            filter.add((ArtifactFilter)includeFilter);
        }
        if (!excludes.isEmpty()) {
            PatternExcludesArtifactFilter excludeFilter = new PatternExcludesArtifactFilter(excludes, actTransitively);
            filter.add((ArtifactFilter)excludeFilter);
        }
        LinkedHashSet<Artifact> copy = new LinkedHashSet<Artifact>(artifacts);
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (filter.include(artifact)) continue;
            it.remove();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((CharSequence)(artifact.getId() + " was removed by one or more filters."));
        }
        return copy;
    }

    public static ScopeFilter newScopeFilter(String scope) {
        HashSet<String> scopes = new HashSet<String>();
        String provided = "provided";
        String compile = "compile";
        String system = "system";
        if ("compile".equals(scope)) {
            scopes.addAll(Arrays.asList(compile, provided, system));
        }
        if ("provided".equals(scope)) {
            scopes.add(provided);
        }
        if ("runtime".equals(scope)) {
            scopes.addAll(Arrays.asList(compile, "runtime"));
        }
        if ("system".equals(scope)) {
            scopes.add(system);
        }
        if ("test".equals(scope)) {
            scopes.addAll(Arrays.asList(compile, provided, "runtime", system, "test"));
        }
        return ScopeFilter.including(scopes);
    }
}

