/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.components.impl;

import io.reactiverse.vertx.maven.plugin.components.Prompter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

@Component(role=Prompter.class, instantiationStrategy="per-lookup")
public class PrompterImpl
implements Prompter {
    private final LineReader console;

    public PrompterImpl() throws IOException {
        Terminal terminal = TerminalBuilder.builder().system(true).jni(true).build();
        this.console = LineReaderBuilder.builder().terminal(terminal).build();
    }

    public PrompterImpl(InputStream in, OutputStream out) throws IOException {
        Terminal terminal = TerminalBuilder.builder().system(false).jni(false).streams(in, out).build();
        this.console = LineReaderBuilder.builder().terminal(terminal).build();
    }

    public LineReader getConsole() {
        return this.console;
    }

    public String prompt(String message, Character mask) throws IOException {
        String value;
        Objects.requireNonNull(message);
        String prompt = String.format("%s: ", message);
        while (StringUtils.isBlank((CharSequence)(value = this.console.readLine(prompt, mask)))) {
        }
        return value;
    }

    @Override
    public String prompt(String message) throws IOException {
        Objects.requireNonNull(message);
        return this.prompt(message, null);
    }

    @Override
    public String promptWithDefaultValue(String message, String defaultValue) throws IOException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(defaultValue);
        String prompt = String.format("%s [%s]: ", message, defaultValue);
        String value = this.console.readLine(prompt);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }
}

