/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.mojos.Archive;
import io.reactiverse.vertx.maven.plugin.mojos.VertxApplicationInfo;
import io.reactiverse.vertx.maven.plugin.utils.MavenUtils;
import io.reactiverse.vertx.maven.plugin.utils.WebJars;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class AbstractVertxMojo
extends AbstractMojo
implements Contextualizable {
    private static final String LAUNCHER = "io.vertx.launcher.application.VertxApplication";
    private static final String LEGACY_LAUNCHER = "io.vertx.core.Launcher";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    File classesDirectory;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(alias="remoteRepositories", defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Component
    protected BuildPluginManager buildPluginManager;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected LifecycleExecutor lifecycleExecutor;
    @Parameter
    protected Archive archive;
    @Parameter(alias="verticle", property="vertx.verticle")
    protected String verticle;
    @Parameter(property="vertx.launcher")
    protected String launcher;
    @Parameter(property="vertx.skip", defaultValue="false")
    protected boolean skip;
    protected PlexusContainer container;
    private List<File> classPathElements;
    private VertxApplicationInfo applicationInfo;

    public MavenProject getProject() {
        return this.project;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public List<File> getClassPathElements() throws MojoExecutionException {
        if (this.classPathElements == null) {
            this.classPathElements = new ArrayList<File>();
            this.classPathElements.add(this.classesDirectory);
            this.classPathElements.addAll(this.extractArtifactPaths(this.project.getArtifacts()));
            this.getLog().debug((CharSequence)("Classpath elements: " + this.classPathElements));
        }
        return this.classPathElements;
    }

    public VertxApplicationInfo getVertxApplicationInfo() throws MojoExecutionException {
        if (this.applicationInfo == null) {
            this.applicationInfo = this.computeApplicationInfo();
        }
        return this.applicationInfo;
    }

    private VertxApplicationInfo computeApplicationInfo() throws MojoExecutionException {
        String vertxVersion = null;
        boolean hasLauncherLegacyCliJar = false;
        boolean hasLauncherApplicationJar = false;
        for (org.apache.maven.artifact.Artifact artifact : this.project.getArtifacts()) {
            if (!"io.vertx".equals(artifact.getGroupId())) continue;
            if ("vertx-core".equals(artifact.getArtifactId())) {
                vertxVersion = artifact.getVersion();
                continue;
            }
            if ("vertx-launcher-legacy-cli".equals(artifact.getArtifactId())) {
                hasLauncherLegacyCliJar = true;
                continue;
            }
            if (!"vertx-launcher-application".equals(artifact.getArtifactId())) continue;
            hasLauncherApplicationJar = true;
        }
        if (vertxVersion == null) {
            throw new MojoExecutionException("Vert.x core not found, it should be a dependency of the project.");
        }
        if (vertxVersion.startsWith("4.")) {
            return this.computeVertx4ApplicationInfo();
        }
        if (vertxVersion.startsWith("5.")) {
            return this.computeVertx5ApplicationInfo(hasLauncherLegacyCliJar, hasLauncherApplicationJar);
        }
        throw new MojoExecutionException("Unsupported Vert.x version: " + vertxVersion);
    }

    private VertxApplicationInfo computeVertx4ApplicationInfo() throws MojoExecutionException {
        String mainVerticle = StringUtils.isBlank((String)this.verticle) ? null : this.verticle.trim();
        String mainClass = StringUtils.isBlank((String)this.launcher) ? LEGACY_LAUNCHER : this.launcher.trim();
        boolean isVertxLauncher = AbstractVertxMojo.isMainClassInstanceOfLauncher(mainClass, LEGACY_LAUNCHER, this.getClassPathElements());
        if (isVertxLauncher && mainVerticle == null) {
            throw new MojoExecutionException("Invalid configuration, the element `verticle` (`vertx.verticle` property) is required.");
        }
        return new VertxApplicationInfo(mainClass, mainVerticle, isVertxLauncher, isVertxLauncher);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VertxApplicationInfo computeVertx5ApplicationInfo(boolean hasLauncherLegacyCliJar, boolean hasLauncherApplicationJar) throws MojoExecutionException {
        boolean isLegacyVertxLauncher;
        boolean isVertxLauncher;
        String mainClass;
        String mainVerticle;
        String string = mainVerticle = StringUtils.isBlank((String)this.verticle) ? null : this.verticle.trim();
        if (StringUtils.isBlank((String)this.launcher)) {
            if (hasLauncherLegacyCliJar && hasLauncherApplicationJar) {
                throw new MojoExecutionException("Invalid configuration, the element `launcher` (`vertx.launcher` property) is required (both `io.vertx:vertx-launcher-application` and `io.vertx:vertx-launcher-legacy-cli` dependencies are present).");
            }
            if (hasLauncherApplicationJar) {
                mainClass = LAUNCHER;
                isVertxLauncher = true;
                isLegacyVertxLauncher = false;
            } else {
                if (!hasLauncherLegacyCliJar) throw new MojoExecutionException("Invalid configuration, you must add the `io.vertx:vertx-launcher-application` or `io.vertx:vertx-launcher-legacy-cli` dependency to the project.");
                mainClass = LEGACY_LAUNCHER;
                isVertxLauncher = true;
                isLegacyVertxLauncher = true;
            }
        } else {
            mainClass = this.launcher.trim();
            if (AbstractVertxMojo.isMainClassInstanceOfLauncher(mainClass, LAUNCHER, this.getClassPathElements())) {
                isVertxLauncher = true;
                isLegacyVertxLauncher = false;
            } else if (AbstractVertxMojo.isMainClassInstanceOfLauncher(mainClass, LEGACY_LAUNCHER, this.getClassPathElements())) {
                isVertxLauncher = true;
                isLegacyVertxLauncher = true;
            } else {
                isVertxLauncher = false;
                isLegacyVertxLauncher = false;
            }
        }
        if (!isVertxLauncher || mainVerticle != null) return new VertxApplicationInfo(mainClass, mainVerticle, isVertxLauncher, isLegacyVertxLauncher);
        throw new MojoExecutionException("Invalid configuration, the element `verticle` (`vertx.verticle` property) is required.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMainClassInstanceOfLauncher(String mainClassName, String launcherClassName, List<File> classPathElements) throws MojoExecutionException {
        if (launcherClassName.equals(mainClassName)) {
            return true;
        }
        URL[] classPathUrls = new URL[classPathElements.size()];
        for (int i = 0; i < classPathElements.size(); ++i) {
            try {
                classPathUrls[i] = classPathElements.get(i).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid classpath element: " + classPathElements.get(i), (Exception)e);
            }
        }
        try (URLClassLoader classLoader = new URLClassLoader(classPathUrls);){
            Class<?> mainClass = classLoader.loadClass(mainClassName);
            for (Class superClass : ClassUtils.getAllSuperclasses(mainClass)) {
                if (!launcherClassName.equals(superClass.getName())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure while inspecting main class hierarchy", (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not find main class: " + mainClassName);
        }
    }

    private Set<File> extractArtifactPaths(Set<org.apache.maven.artifact.Artifact> artifacts) throws MojoExecutionException {
        try {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (org.apache.maven.artifact.Artifact e : artifacts) {
                File resolvedArtifact;
                if (!e.getScope().equals("compile") && !e.getScope().equals("runtime") || !e.getType().equals("jar") || WebJars.isWebJar(e.getFile()) || (resolvedArtifact = this.resolveArtifact(MavenUtils.asMavenCoordinates(e))) == null) continue;
                files.add(resolvedArtifact.getAbsoluteFile());
            }
            return files;
        }
        catch (IOException | ArtifactResolutionException ex) {
            throw new MojoExecutionException("Unable to extract artifact paths", (Exception)ex);
        }
    }

    private File resolveArtifact(String artifact) throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)new DefaultArtifact(artifact));
        ArtifactResult artifactResult = this.repositorySystem.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, artifactRequest);
        if (artifactResult.isResolved()) {
            this.getLog().debug((CharSequence)("Resolved: " + artifactResult.getArtifact().getArtifactId()));
            return artifactResult.getArtifact().getFile();
        }
        this.getLog().warn((CharSequence)("Unable to resolve artifact: " + artifact));
        return null;
    }
}

