/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.components.ManifestCustomizerService;
import io.reactiverse.vertx.maven.plugin.components.PackageConfig;
import io.reactiverse.vertx.maven.plugin.components.PackageService;
import io.reactiverse.vertx.maven.plugin.components.PackagingException;
import io.reactiverse.vertx.maven.plugin.components.ServiceFileCombinationConfig;
import io.reactiverse.vertx.maven.plugin.components.ServiceFileCombiner;
import io.reactiverse.vertx.maven.plugin.components.ServiceUtils;
import io.reactiverse.vertx.maven.plugin.model.CombinationStrategy;
import io.reactiverse.vertx.maven.plugin.mojos.AbstractVertxMojo;
import io.reactiverse.vertx.maven.plugin.mojos.Archive;
import io.reactiverse.vertx.maven.plugin.mojos.DependencySet;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageMojo
extends AbstractVertxMojo {
    @Parameter(name="serviceProviderCombination", defaultValue="COMBINE")
    protected CombinationStrategy serviceProviderCombination;
    @Parameter(name="classifier")
    protected String classifier;
    @Parameter(name="attach", defaultValue="true")
    protected boolean attach;
    @Component
    protected PackageService packageService;
    @Component
    protected ServiceFileCombiner combiner;
    private static final String JAR_EXTENSION = ".jar";

    public static String computeOutputName(Archive archive, MavenProject project, String classifier) {
        String output = archive.getOutputFileName();
        if (!StringUtils.isBlank((CharSequence)output)) {
            if (!output.endsWith(JAR_EXTENSION)) {
                output = output + JAR_EXTENSION;
            }
            return output;
        }
        String finalName = project.getBuild().getFinalName();
        if (finalName != null) {
            if (finalName.endsWith(JAR_EXTENSION)) {
                finalName = finalName.substring(0, finalName.length() - JAR_EXTENSION.length());
            }
            if (classifier != null && !classifier.isEmpty()) {
                finalName = finalName + "-" + classifier;
            }
            finalName = finalName + JAR_EXTENSION;
            return finalName;
        }
        finalName = project.getArtifactId() + "-" + project.getVersion();
        if (classifier != null && !classifier.isEmpty()) {
            finalName = finalName + "-" + classifier;
        }
        finalName = finalName + JAR_EXTENSION;
        return finalName;
    }

    public void execute() throws MojoExecutionException {
        File jar;
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:package skipped by configuration");
            return;
        }
        this.fixEmptyClassifier();
        if (StringUtils.isBlank((CharSequence)this.classifier) && !this.attach) {
            throw new MojoExecutionException("Cannot disable attachment of the created archive when it's the main artifact");
        }
        Archive updatedArchive = this.computeArchive();
        this.combiner.doCombine((ServiceFileCombinationConfig)new ServiceFileCombinationConfig().setStrategy(this.serviceProviderCombination).setProject(this.project).setArchive(updatedArchive).setMojo(this).setArtifacts(this.project.getArtifacts()));
        try {
            File buildDir = new File(this.projectBuildDir);
            if (!buildDir.isDirectory() && !buildDir.mkdirs()) {
                this.getLog().error((CharSequence)("An error has occurred while creating the directory defined by projectBuildDir: " + this.projectBuildDir));
            }
            jar = this.packageService.doPackage(((PackageConfig)new PackageConfig().setArtifacts(this.project.getArtifacts())).setMojo(this).setOutput(new File(buildDir, PackageMojo.computeOutputName(this.archive, this.project, this.classifier))).setProject(this.project).setArchive(this.archive));
        }
        catch (PackagingException e) {
            throw new MojoExecutionException("Unable to build the fat jar", (Exception)e);
        }
        this.attachIfNeeded(jar);
    }

    private Archive computeArchive() throws MojoExecutionException {
        if (this.archive == null) {
            this.archive = ServiceUtils.getDefaultFatJar();
        }
        if (this.archive.getDependencySets().isEmpty()) {
            this.archive.addDependencySet(DependencySet.ALL);
        }
        this.archive.getManifest().putIfAbsent("Main-Class", this.getVertxApplicationInfo().mainClass());
        String mainVerticle = this.getVertxApplicationInfo().mainVerticle();
        if (mainVerticle != null) {
            this.archive.getManifest().putIfAbsent("Main-Verticle", mainVerticle);
        }
        List<ManifestCustomizerService> customizers = this.getManifestCustomizers();
        customizers.forEach(customizer -> this.archive.getManifest().putAll(customizer.getEntries(this, this.project)));
        if (this.archive.getFileCombinationPatterns().isEmpty()) {
            this.archive.addFileCombinationPattern("META-INF/services/*");
            this.archive.addFileCombinationPattern("META-INF/spring.*");
            this.archive.addFileCombinationPattern("META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat");
        }
        return this.archive;
    }

    private List<ManifestCustomizerService> getManifestCustomizers() throws MojoExecutionException {
        List customizers;
        try {
            customizers = this.container.lookupList(ManifestCustomizerService.class);
        }
        catch (ComponentLookupException e) {
            this.getLog().debug((CharSequence)"ManifestCustomerService lookup failed", (Throwable)e);
            throw new MojoExecutionException("Unable to retrieve the " + ManifestCustomizerService.class.getName() + " components");
        }
        return customizers;
    }

    private void attachIfNeeded(File jar) {
        if (jar.isFile() && this.classifier != null && this.attach) {
            DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
            DefaultArtifact vertxJarArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "jar", this.classifier, (ArtifactHandler)handler);
            vertxJarArtifact.setFile(jar);
            this.project.addAttachedArtifact((Artifact)vertxJarArtifact);
        }
    }

    private void fixEmptyClassifier() {
        if (StringUtils.isBlank((CharSequence)this.classifier)) {
            this.getLog().debug((CharSequence)"The classifier is empty, it won't be used");
            this.classifier = null;
        }
    }
}

