/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.components.Prompter;
import io.reactiverse.vertx.maven.plugin.utils.MojoUtils;
import io.reactiverse.vertx.maven.plugin.utils.SetupTemplateUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="setup", requiresProject=false)
public class SetupMojo
extends AbstractMojo {
    public static final String JAVA_EXTENSION = ".java";
    public static final String VERTX_CORE_VERSION = "vertx-core-version";
    public static final String VERTX_GROUP_ID = "io.vertx";
    public static final String VERTX_BOM_ARTIFACT_ID = "vertx-stack-depchain";
    public static final String VERTX_CORE_ARTIFACT_ID = "vertx-core";
    public static final String VERTX_LAUNCHER_APPLICATION_ARTIFACT_ID = "vertx-launcher-application";
    private static final String PLUGIN_GROUP_ID = "io.reactiverse";
    private static final String PLUGIN_ARTIFACT_ID = "vertx-maven-plugin";
    private static final String VERTX_MAVEN_PLUGIN_VERSION_PROPERTY = "vertx-maven-plugin-version";
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="projectGroupId")
    protected String projectGroupId;
    @Parameter(property="projectArtifactId")
    protected String projectArtifactId;
    @Parameter(property="projectVersion", defaultValue="1.0-SNAPSHOT")
    protected String projectVersion;
    @Parameter(property="vertxBom", defaultValue="vertx-stack-depchain")
    protected String vertxBom;
    @Parameter(property="vertxVersion")
    protected String vertxVersion;
    @Parameter(property="verticle")
    protected String verticle;
    @Parameter(property="javaVersion")
    protected String javaVersion;
    @Component
    protected Prompter prompter;

    public void execute() throws MojoExecutionException {
        File pomFile = this.project.getFile();
        if (pomFile == null || !pomFile.isFile()) {
            pomFile = this.createPomFileFromUserInputs();
        }
        Model model = this.project.getOriginalModel().clone();
        this.vertxVersion = this.vertxVersion == null ? MojoUtils.getVersion(VERTX_CORE_VERSION) : this.vertxVersion;
        this.createDirectories();
        SetupTemplateUtils.createVerticle(this.project, this.vertxVersion, this.verticle, this.getLog());
        Optional<Plugin> vmPlugin = MojoUtils.hasPlugin(this.project, "io.reactiverse:vertx-maven-plugin");
        if (vmPlugin.isPresent()) {
            return;
        }
        model.getProperties().putIfAbsent("vertx-maven-plugin.version", MojoUtils.getVersion(VERTX_MAVEN_PLUGIN_VERSION_PROPERTY));
        model.getProperties().putIfAbsent("vertx.version", this.vertxVersion);
        if (!StringUtils.isBlank((CharSequence)this.verticle)) {
            if (this.verticle.endsWith(JAVA_EXTENSION)) {
                this.verticle = this.verticle.substring(0, this.verticle.length() - JAVA_EXTENSION.length());
            }
            model.getProperties().putIfAbsent("vertx.verticle", this.verticle);
        }
        this.addVertxBom(model);
        Stream.Builder<String> deps = Stream.builder().add(VERTX_CORE_ARTIFACT_ID);
        if (this.vertxVersion.startsWith("5.")) {
            deps.add(VERTX_LAUNCHER_APPLICATION_ARTIFACT_ID);
        }
        this.addVertxDependencies(model, deps.build().collect(Collectors.toCollection(LinkedHashSet::new)));
        Plugin vertxMavenPlugin = MojoExecutor.plugin((String)PLUGIN_GROUP_ID, (String)PLUGIN_ARTIFACT_ID, (String)"${vertx-maven-plugin.version}");
        if (this.isParentPom(model)) {
            this.addPluginManagementSection(model, vertxMavenPlugin);
            vertxMavenPlugin = MojoExecutor.plugin((String)PLUGIN_GROUP_ID, (String)PLUGIN_ARTIFACT_ID);
        } else {
            vertxMavenPlugin = MojoExecutor.plugin((String)PLUGIN_GROUP_ID, (String)PLUGIN_ARTIFACT_ID, (String)"${vertx-maven-plugin.version}");
        }
        PluginExecution pluginExec = new PluginExecution();
        pluginExec.addGoal("initialize");
        pluginExec.addGoal("package");
        pluginExec.setId("vmp");
        vertxMavenPlugin.addExecution(pluginExec);
        Build build = this.createBuildSectionIfRequired(model);
        build.getPlugins().add(vertxMavenPlugin);
        this.save(pomFile, model);
    }

    private Build createBuildSectionIfRequired(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        if (build.getPlugins() == null) {
            build.setPlugins(new ArrayList());
        }
        return build;
    }

    private void addPluginManagementSection(Model model, Plugin vertxMavenPlugin) {
        if (model.getBuild().getPluginManagement() != null) {
            if (model.getBuild().getPluginManagement().getPlugins() == null) {
                model.getBuild().getPluginManagement().setPlugins(new ArrayList());
            }
            model.getBuild().getPluginManagement().getPlugins().add(vertxMavenPlugin);
        }
    }

    private File createPomFileFromUserInputs() throws MojoExecutionException {
        Model model;
        String currentDirectory = System.getProperty("user.dir");
        this.getLog().info((CharSequence)("Creating a new pom.xml file in: " + currentDirectory));
        File pomFile = new File(currentDirectory, "pom.xml");
        try {
            this.projectGroupId = this.promptOrUseDefault(this.projectGroupId, "Set the project groupId", "io.vertx.example");
            this.projectArtifactId = this.promptOrUseDefault(this.projectArtifactId, "Set the project artifactId", "my-vertx-project");
            this.projectVersion = this.promptOrUseDefault(this.projectVersion, "Set the project version", "1.0-SNAPSHOT");
            this.vertxVersion = this.promptOrUseDefault(this.vertxVersion, "Set the Vert.x version", MojoUtils.getVersion(VERTX_CORE_VERSION));
            this.verticle = this.promptOrUseDefault(this.verticle, "Set the verticle class name", this.projectGroupId.replace("-", ".").replace("_", ".") + ".MainVerticle");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while prompting setup config", (Exception)e);
        }
        if (this.verticle != null && this.verticle.endsWith(JAVA_EXTENSION)) {
            this.verticle = this.verticle.substring(0, this.verticle.length() - JAVA_EXTENSION.length());
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mProjectGroupId", this.projectGroupId);
        context.put("mProjectArtifactId", this.projectArtifactId);
        context.put("mProjectVersion", this.projectVersion);
        context.put("vertxBom", this.vertxBom != null ? this.vertxBom : VERTX_BOM_ARTIFACT_ID);
        context.put("vertxVersion", this.vertxVersion != null ? this.vertxVersion : MojoUtils.getVersion(VERTX_CORE_VERSION));
        context.put("vertxVerticle", this.verticle);
        context.put("vmpVersion", MojoUtils.getVersion(VERTX_MAVEN_PLUGIN_VERSION_PROPERTY));
        context.put("javaVersion", this.javaVersion != null ? this.javaVersion : SystemUtils.JAVA_SPECIFICATION_VERSION);
        SetupTemplateUtils.createPom(context, pomFile);
        MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
        try (InputStream is = Files.newInputStream(pomFile.toPath(), new OpenOption[0]);){
            model = xpp3Reader.read(is);
        }
        catch (IOException | XmlPullParserException e) {
            throw new MojoExecutionException("Error while reading POM file model", (Exception)e);
        }
        this.project = new MavenProject(model);
        this.project.setPomFile(pomFile);
        this.project.setOriginalModel(model);
        return pomFile;
    }

    private String promptOrUseDefault(String value, String msg, String defaultValue) throws IOException {
        if (value != null) {
            return value;
        }
        if (this.mavenSession.getRequest().isInteractiveMode()) {
            return this.prompter.promptWithDefaultValue(msg, defaultValue);
        }
        return defaultValue;
    }

    private void save(File pomFile, Model model) throws MojoExecutionException {
        MavenXpp3Writer xpp3Writer = new MavenXpp3Writer();
        try (FileWriter pomFileWriter = new FileWriter(pomFile);){
            xpp3Writer.write((Writer)pomFileWriter, model);
            pomFileWriter.flush();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write the pom.xml file", (Exception)e);
        }
    }

    private void createDirectories() {
        boolean res;
        File root = this.project.getBasedir();
        File source = new File(root, "src/main/java");
        File resources = new File(root, "src/main/resources");
        File test = new File(root, "src/test/java");
        String prefix = "Creation of ";
        if (!source.isDirectory()) {
            res = source.mkdirs();
            this.getLog().debug((CharSequence)(prefix + source.getAbsolutePath() + " : " + res));
        }
        if (!resources.isDirectory()) {
            res = resources.mkdirs();
            this.getLog().debug((CharSequence)(prefix + resources.getAbsolutePath() + " : " + res));
        }
        if (!test.isDirectory()) {
            res = test.mkdirs();
            this.getLog().debug((CharSequence)(prefix + test.getAbsolutePath() + " : " + res));
        }
    }

    private boolean isParentPom(Model model) {
        return "pom".equals(model.getPackaging());
    }

    private void addVertxDependencies(Model model, LinkedHashSet<String> toAdd) {
        for (Dependency dependency : model.getDependencies()) {
            if (!VERTX_GROUP_ID.equals(dependency.getGroupId())) continue;
            toAdd.remove(dependency.getArtifactId());
        }
        for (String artifactId : toAdd) {
            model.getDependencies().add(MojoExecutor.dependency((String)VERTX_GROUP_ID, (String)artifactId, null));
        }
    }

    private void addVertxBom(Model model) {
        DependencyManagement dependencyManagement = model.getDependencyManagement();
        if (dependencyManagement != null) {
            for (Dependency dependency : dependencyManagement.getDependencies()) {
                if (!VERTX_GROUP_ID.equals(dependency.getGroupId()) || !this.vertxBom.equals(dependency.getArtifactId())) continue;
                return;
            }
        } else {
            dependencyManagement = new DependencyManagement();
            model.setDependencyManagement(dependencyManagement);
        }
        Dependency dependency = MojoExecutor.dependency((String)VERTX_GROUP_ID, (String)this.vertxBom, (String)"${vertx.version}");
        dependency.setType("pom");
        dependency.setScope("import");
        dependencyManagement.addDependency(dependency);
    }
}

