/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.utils;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;

public class SetupTemplateUtils {
    static final Configuration cfg;
    static final Log logger;
    public static final String JAVA_EXTENSION = ".java";

    public static void createPom(Map<String, String> context, File pomFile) throws MojoExecutionException {
        try {
            Template temp = cfg.getTemplate("templates/pom-template.ftl");
            FileWriter out = new FileWriter(pomFile);
            temp.process(context, (Writer)out);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to generate pom.xml", e);
        }
    }

    public static void createVerticle(MavenProject project, String vertxVersion, String verticle, Log log) throws MojoExecutionException {
        String className;
        if (StringUtils.isBlank((CharSequence)verticle)) {
            return;
        }
        log.info((CharSequence)("Creating verticle " + verticle));
        File root = new File(project.getBasedir(), "src/main/java");
        String packageName = null;
        if (verticle.endsWith(JAVA_EXTENSION)) {
            verticle = verticle.substring(0, verticle.length() - JAVA_EXTENSION.length());
        }
        if (verticle.contains(".")) {
            int idx = verticle.lastIndexOf(46);
            packageName = verticle.substring(0, idx);
            className = verticle.substring(idx + 1);
        } else {
            className = verticle;
        }
        if (packageName != null) {
            File packageDir = new File(root, packageName.replace('.', '/'));
            if (!packageDir.exists()) {
                packageDir.mkdirs();
                log.info((CharSequence)("Creating directory " + packageDir.getAbsolutePath()));
            }
            root = packageDir;
        }
        File classFile = new File(root, className + JAVA_EXTENSION);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("futurizedVerticle", vertxVersion.startsWith("5."));
        context.put("className", className);
        if (packageName != null) {
            context.put("packageName", packageName);
        }
        try {
            Template temp = cfg.getTemplate("templates/verticle-template.ftl");
            FileWriter out = new FileWriter(classFile);
            temp.process(context, (Writer)out);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to generate verticle", e);
        }
    }

    static {
        logger = new SystemStreamLog();
        cfg = new Configuration(Configuration.VERSION_2_3_23);
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(SetupTemplateUtils.class, "/"));
    }
}

