/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.codehaus.plexus.util.StringUtils;

public class VertxAppBuilder {
    private final File java;
    private final List<String> jvmArgs = new ArrayList<String>();
    private final List<File> classpathElements = new ArrayList<File>();
    private final String mainClass;
    private final List<String> appArgs = new ArrayList<String>();
    private File workDir;
    private final Map<String, String> env = new HashMap<String, String>();

    public VertxAppBuilder(File java, String mainClass) {
        this.java = Objects.requireNonNull(java);
        if (!java.canExecute()) {
            throw new IllegalArgumentException("Java command not executable: " + java.getAbsolutePath());
        }
        if (StringUtils.isBlank((String)mainClass)) {
            throw new IllegalArgumentException("mainClass must not be blank");
        }
        this.mainClass = mainClass;
    }

    public VertxAppBuilder addJvmArg(String jvmArg) {
        this.jvmArgs.add(Objects.requireNonNull(jvmArg));
        return this;
    }

    public VertxAppBuilder addClasspathElement(File classpathElement) {
        this.classpathElements.add(Objects.requireNonNull(classpathElement));
        return this;
    }

    public VertxAppBuilder addAppArg(String appArg) {
        this.appArgs.add(Objects.requireNonNull(appArg));
        return this;
    }

    public VertxAppBuilder workDir(File workDir) {
        this.workDir = workDir;
        return this;
    }

    public VertxAppBuilder env(String key, String value) {
        this.env.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
        return this;
    }

    public ProcessBuilder processBuilder() {
        ProcessBuilder builder = new ProcessBuilder(this.getCommand()).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).redirectInput(ProcessBuilder.Redirect.INHERIT).directory(this.workDir);
        StringJoiner joiner = new StringJoiner(File.pathSeparator);
        for (File elem : this.classpathElements) {
            joiner.add(StringUtils.quoteAndEscape((String)elem.getAbsolutePath(), (char)'\"'));
        }
        Map<String, String> environment = builder.environment();
        environment.put("CLASSPATH", joiner.toString());
        environment.putAll(this.env);
        return builder;
    }

    private List<String> getCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(StringUtils.quoteAndEscape((String)this.java.getAbsolutePath(), (char)'\"'));
        command.addAll(this.jvmArgs);
        command.add(this.mainClass);
        command.addAll(this.appArgs);
        return command;
    }
}

