/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;

public class WebJars {
    private static final String WEBJAR_LOCATION = "META-INF/resources/webjars/";
    private static final Pattern WEBJAR_INTERNAL_PATH_REGEX = Pattern.compile("([^/]+)/([^/]+)/(.*)");

    public static boolean isWebJar(File file) throws IOException {
        if (file != null && file.isFile() && file.getName().endsWith(".jar")) {
            try (JarFile jar = new JarFile(file);){
                if (jar.getJarEntry(WEBJAR_LOCATION) == null) {
                    boolean bl = false;
                    return bl;
                }
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().startsWith(WEBJAR_LOCATION)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public static void extract(File in, File out, boolean stripVersion) throws IOException {
        try (ZipFile file = new ZipFile(in);){
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                WebJars.unzipWebJarFile(out, stripVersion, file, entries);
            }
        }
    }

    private static void unzipWebJarFile(File out, boolean stripVersion, ZipFile file, Enumeration<? extends ZipEntry> entries) throws IOException {
        ZipEntry entry = entries.nextElement();
        if (entry.getName().startsWith(WEBJAR_LOCATION) && !entry.isDirectory()) {
            File output = WebJars.getOutput(out, stripVersion, entry.getName().substring(WEBJAR_LOCATION.length()));
            try (InputStream stream = file.getInputStream(entry);){
                output.getParentFile().mkdirs();
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)output);
            }
        }
    }

    private static File getOutput(File out, boolean stripVersion, String path) {
        Matcher matcher;
        if (stripVersion && (matcher = WEBJAR_INTERNAL_PATH_REGEX.matcher(path)).matches()) {
            return new File(out, matcher.group(1) + "/" + matcher.group(3));
        }
        return new File(out, path);
    }
}

