/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.components.impl;

import io.reactiverse.vertx.maven.plugin.components.ManifestCustomizerService;
import io.reactiverse.vertx.maven.plugin.model.ExtraManifestKeys;
import io.reactiverse.vertx.maven.plugin.mojos.AbstractVertxMojo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ManifestCustomizerService.class, hint="project")
public class ProjectManifestCustomizer
implements ManifestCustomizerService {
    @Override
    public Map<String, String> getEntries(AbstractVertxMojo mojo, MavenProject project) {
        List dependencies;
        HashMap<String, String> attributes = new HashMap<String, String>();
        Model model = project.getModel();
        attributes.put(ExtraManifestKeys.PROJECT_ARTIFACT_ID.header(), model.getArtifactId());
        attributes.put(ExtraManifestKeys.PROJECT_GROUP_ID.header(), model.getGroupId());
        attributes.put(ExtraManifestKeys.PROJECT_VERSION.header(), model.getVersion());
        attributes.put(ExtraManifestKeys.PROJECT_NAME.header(), model.getName() == null ? model.getArtifactId() : model.getName());
        attributes.put(ExtraManifestKeys.BUILD_TIMESTAMP.header(), ProjectManifestCustomizer.manifestTimestampFormat(new Date()));
        if (project.getUrl() != null) {
            attributes.put(ExtraManifestKeys.PROJECT_URL.header(), project.getUrl());
        }
        if ((dependencies = model.getDependencies()) != null && !dependencies.isEmpty()) {
            String deps = dependencies.stream().filter(d -> "compile".equals(d.getScope()) || null == d.getScope()).map(ProjectManifestCustomizer::asCoordinates).collect(Collectors.joining(" "));
            attributes.put(ExtraManifestKeys.PROJECT_DEPS.header(), deps);
        }
        return attributes;
    }

    public static String manifestTimestampFormat(Date date) {
        return new SimpleDateFormat("yyyyMMdd HH:mm:ss z").format(date);
    }

    private static String asCoordinates(Dependency dependency) {
        StringBuilder dependencyCoordinates = new StringBuilder().append(dependency.getGroupId()).append(":").append(dependency.getArtifactId()).append(":").append(dependency.getVersion());
        if (dependency.getClassifier() != null) {
            dependencyCoordinates.append(":").append(dependency.getClassifier());
        }
        return dependencyCoordinates.toString();
    }
}

