/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.mojos.AbstractVertxMojo;
import io.reactiverse.vertx.maven.plugin.mojos.MojoSpy;
import io.reactiverse.vertx.maven.plugin.utils.ConfigConverterUtil;
import io.reactiverse.vertx.maven.plugin.utils.FileChangesHelper;
import io.reactiverse.vertx.maven.plugin.utils.MavenExecutionUtils;
import io.reactiverse.vertx.maven.plugin.utils.MojoExecutor;
import io.reactiverse.vertx.maven.plugin.utils.MojoUtils;
import io.reactiverse.vertx.maven.plugin.utils.VertxAppBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

@Mojo(name="run", threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RunMojo
extends AbstractVertxMojo {
    private static final String WEB_ENVIRONMENT_VARIABLE_NAME = "VERTXWEB_ENVIRONMENT";
    @Parameter(property="vertx.redeploy.enabled", defaultValue="true")
    boolean redeploy;
    @Parameter(defaultValue="${project.basedir}/src/main")
    File redeployRootDirectory;
    @Parameter
    List<String> redeployIncludes;
    @Parameter
    List<String> redeployExcludes;
    @Parameter(property="vertx.redeploy.scan.period", defaultValue="1000")
    long redeployScanPeriod;
    @Parameter(property="vertx.redeploy.grace.period", defaultValue="1000")
    long redeployGracePeriod;
    @Parameter(property="vertxweb.environment")
    String vertxWebEnvironment;
    @Parameter(alias="options", property="vertx.options")
    File options;
    @Parameter(alias="config", property="vertx.config")
    File config;
    @Parameter(alias="workDirectory", property="vertx.directory", defaultValue="${project.basedir}")
    File workDirectory;
    @Parameter(alias="jvmArgs", property="vertx.jvmArguments")
    List<String> jvmArgs;
    @Parameter(name="runArgs", property="vertx.runArgs")
    List<String> runArgs;
    @Parameter(property="vertx.disable.blocked.thread.checker", defaultValue="true")
    boolean disableBlockedThreadChecker;
    @Parameter(property="vertx.debug", defaultValue="true")
    boolean debug;
    @Parameter(property="vertx.debug.suspend", defaultValue="false")
    boolean debugSuspend;
    @Parameter(property="vertx.debug.port", defaultValue="5005")
    String debugPort;
    private Properties systemEnvVars;
    private File java;
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private Process vertxApp;
    private volatile boolean stop;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:run skipped by configuration");
            return;
        }
        this.compileIfNeeded();
        this.systemEnvVars = CommandLineUtils.getSystemEnvVars();
        this.java = this.findJava();
        this.getLog().info((CharSequence)("Found java executable: " + this.java));
        this.vertxWebEnvironment = StringUtils.isBlank((String)this.vertxWebEnvironment) ? this.systemEnvVars.getProperty(WEB_ENVIRONMENT_VARIABLE_NAME, "dev") : this.vertxWebEnvironment.trim();
        this.getLog().info((CharSequence)("Using web environment: " + this.vertxWebEnvironment));
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHookTask()));
        try (FileChangesHelper fileChangesHelper = new FileChangesHelper(this.getLog(), this.redeployRootDirectory, this.redeployIncludes, this.redeployExcludes);){
            this.buildLoop(fileChangesHelper);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure while running Vert.x application", e);
        }
        finally {
            this.destroyApp();
            this.stopLatch.countDown();
        }
    }

    private void compileIfNeeded() {
        File classes = new File(this.project.getBuild().getOutputDirectory());
        if (!classes.isDirectory()) {
            MavenExecutionUtils.execute("compile", this.project, this.mavenSession, this.lifecycleExecutor, this.container);
        }
    }

    private File findJava() throws MojoExecutionException {
        File java;
        File binDir;
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            Properties envVars = this.systemEnvVars;
            javaHome = envVars.getProperty("JAVA_HOME");
        }
        if (javaHome != null && (binDir = new File(javaHome, "bin")).exists() && binDir.isDirectory() && (java = new File(binDir, SystemUtils.IS_OS_WINDOWS ? "java.exe" : "java")).isFile() && java.canExecute()) {
            return java;
        }
        throw new MojoExecutionException("Unable to find the Java executable.");
    }

    private void buildLoop(FileChangesHelper fileChangesHelper) throws MojoExecutionException {
        while (!this.stop) {
            VertxAppBuilder appBuilder = new VertxAppBuilder(this.java, this.getVertxApplicationInfo().mainClass()).env(WEB_ENVIRONMENT_VARIABLE_NAME, this.vertxWebEnvironment).workDir(this.workDirectory);
            for (File classPathElement : this.getClassPathElements()) {
                appBuilder.addClasspathElement(classPathElement);
            }
            if (this.debug || this.disableBlockedThreadChecker) {
                appBuilder.addJvmArg(String.format("-Dvertx.options.maxEventLoopExecuteTime=%d", Long.MAX_VALUE)).addJvmArg(String.format("-Dvertx.options.maxWorkerExecuteTime=%d", Long.MAX_VALUE));
            }
            if (this.debug) {
                appBuilder.addJvmArg(String.format("-agentlib:jdwp=transport=dt_socket,server=y,suspend=%s,address=%s", this.debugSuspend ? "y" : "n", this.debugPort));
            }
            if (this.jvmArgs != null) {
                for (String jvmArg : this.jvmArgs) {
                    if (!StringUtils.isNotBlank((String)jvmArg)) continue;
                    appBuilder.addJvmArg(jvmArg.trim());
                }
            }
            if (this.getVertxApplicationInfo().isVertxLauncher()) {
                File configFile;
                if (this.getVertxApplicationInfo().isLegacyVertxLauncher()) {
                    appBuilder.addAppArg("run");
                }
                appBuilder.addAppArg(this.getVertxApplicationInfo().mainVerticle());
                File optionsFile = this.scanAndLoad("options", this.options);
                if (optionsFile != null) {
                    appBuilder.addAppArg("-options").addAppArg(StringUtils.quoteAndEscape((String)optionsFile.getAbsolutePath(), (char)'\"'));
                }
                if ((configFile = this.scanAndLoad("application", this.config)) != null) {
                    appBuilder.addAppArg("-conf").addAppArg(StringUtils.quoteAndEscape((String)configFile.getAbsolutePath(), (char)'\"'));
                }
            }
            if (this.runArgs != null) {
                for (String runArg : this.runArgs) {
                    if (!StringUtils.isNotBlank((String)runArg)) continue;
                    try {
                        for (String arg : CommandLineUtils.translateCommandline((String)runArg.trim())) {
                            appBuilder.addAppArg(arg);
                        }
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Failed to parse Vert.x run argument:" + runArg, e);
                    }
                }
            }
            this.getLog().info((CharSequence)"Launching Vert.x Application");
            ProcessBuilder processBuilder = appBuilder.processBuilder();
            try {
                this.vertxApp = processBuilder.start();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to start Vert.x Application", (Exception)e);
            }
            if (this.redeploy) {
                try {
                    Thread.sleep(this.redeployGracePeriod);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new MojoExecutionException("Interrupted while sleeping for grace period", (Exception)e);
                }
            }
            while (true) {
                if (!this.vertxApp.isAlive()) {
                    this.getLog().info((CharSequence)"Vert.x Application has stopped");
                    return;
                }
                if (this.stop) {
                    return;
                }
                if (!this.redeploy) continue;
                if (fileChangesHelper.foundChanges()) break;
                try {
                    Thread.sleep(this.redeployScanPeriod);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new MojoExecutionException("Interrupted while sleeping for scan period", (Exception)e);
                }
            }
            if (!this.destroyApp()) {
                throw new MojoExecutionException("Failed to destroy Vert.x Application gracefully");
            }
            this.getLog().info((CharSequence)"Redeploying Vert.x Application");
            Set artifacts = this.project.getArtifacts();
            for (Callable callable : this.computeExecutionChain(artifacts)) {
                try {
                    callable.call();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to build Vert.x Application", e);
                }
            }
        }
    }

    private List<Callable<Void>> computeExecutionChain(Set<Artifact> artifacts) {
        ArrayList<Callable<Void>> list = new ArrayList<Callable<Void>>();
        ExecutionListener executionListener = this.mavenSession.getRequest().getExecutionListener();
        if (executionListener instanceof MojoSpy) {
            MojoSpy spy = (MojoSpy)executionListener;
            for (MojoExecution execution : spy.getMojos()) {
                Callable<Void> task = this.toTask(execution, artifacts);
                list.add(task);
            }
        }
        if (list.isEmpty()) {
            this.getLog().info((CharSequence)"No plugin execution collected. The vertx:initialize goal has not been run beforehand. Only handling resources and java compilation");
            list.add(new JavaBuildCallback());
            list.add(new ResourceBuildCallback());
        }
        return list;
    }

    private Callable<Void> toTask(MojoExecution execution, Set<Artifact> artifacts) {
        MojoExecutor executor = new MojoExecutor(execution, this.project, this.mavenSession, this.buildPluginManager);
        return () -> {
            this.project.setArtifacts(artifacts);
            try {
                this.getLog().info((CharSequence)String.format(">>> %s:%s:%s (%s) @%s", execution.getArtifactId(), execution.getVersion(), execution.getGoal(), execution.getExecutionId(), this.project.getArtifactId()));
                executor.execute();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error while doing incremental build", (Throwable)e);
            }
            return null;
        };
    }

    private File lookForConfiguration(String filename) {
        File confBaseDir = new File(this.project.getBasedir(), "src/main/conf");
        if (!confBaseDir.isDirectory()) {
            return null;
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(confBaseDir);
        directoryScanner.setIncludes(new String[]{filename + ".json", filename + ".yml", filename + ".yaml"});
        directoryScanner.scan();
        return Arrays.stream(directoryScanner.getIncludedFiles()).map(found -> new File(confBaseDir, (String)found)).findFirst().orElse(null);
    }

    File scanAndLoad(String configName, File userProvided) throws MojoExecutionException {
        File file;
        if (userProvided != null) {
            if (!userProvided.isFile()) {
                this.getLog().error((CharSequence)("Cannot load the configuration - file " + userProvided.getAbsolutePath() + " does not exist"));
                return userProvided;
            }
            file = userProvided;
        } else {
            file = this.lookForConfiguration(configName);
            if (file == null) {
                this.getLog().debug((CharSequence)"No configuration found");
                return null;
            }
        }
        return this.isYaml(file) ? this.convertYamlToJson(file) : file;
    }

    private File convertYamlToJson(File yamlFile) throws MojoExecutionException {
        File jsonConfDir = new File(this.projectBuildDir, "conf");
        jsonConfDir.mkdirs();
        String output = FilenameUtils.removeExtension((String)yamlFile.getName()) + ".json";
        File convertedJsonFile = new File(jsonConfDir, output);
        try {
            ConfigConverterUtil.convertYamlToJson(yamlFile, convertedJsonFile);
            this.getLog().debug((CharSequence)(yamlFile.getAbsolutePath() + " converted to " + convertedJsonFile.getAbsolutePath()));
            return convertedJsonFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error loading or converting the configuration file:" + yamlFile, e);
        }
    }

    private boolean isYaml(File file) {
        if (file != null) {
            String fileName = file.getName();
            return fileName.endsWith(".yaml") || fileName.endsWith(".yml");
        }
        return false;
    }

    private boolean destroyApp() {
        if (this.vertxApp != null) {
            this.vertxApp.destroy();
            try {
                if (!this.vertxApp.waitFor(30L, TimeUnit.SECONDS)) {
                    this.vertxApp.destroyForcibly();
                    return false;
                }
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.vertxApp.destroyForcibly();
                return false;
            }
        }
        return false;
    }

    private class ShutdownHookTask
    implements Runnable {
        private ShutdownHookTask() {
        }

        @Override
        public void run() {
            RunMojo.this.getLog().info((CharSequence)"Shutting down...");
            RunMojo.this.stop = true;
            try {
                RunMojo.this.stopLatch.await();
            }
            catch (InterruptedException e) {
                RunMojo.this.getLog().warn((CharSequence)"Interrupted while waiting for shutdown", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public final class ResourceBuildCallback
    implements Callable<Void> {
        @Override
        public Void call() throws Exception {
            MojoUtils.copyResources(RunMojo.this.project, RunMojo.this.mavenSession, RunMojo.this.buildPluginManager);
            return null;
        }
    }

    public final class JavaBuildCallback
    implements Callable<Void> {
        @Override
        public Void call() throws Exception {
            MojoUtils.compile(RunMojo.this.project, RunMojo.this.mavenSession, RunMojo.this.buildPluginManager);
            return null;
        }
    }
}

