/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

public class VertxApplicationInfo {
    private final String mainClass;
    private final String mainVerticle;
    private final boolean isVertxLauncher;
    private final boolean isLegacyVertxLauncher;

    public VertxApplicationInfo(String mainClass, String mainVerticle, boolean isVertxLauncher, boolean isLegacyVertxLauncher) {
        if (mainVerticle == null && isVertxLauncher) {
            throw new IllegalArgumentException("Main verticle cannot be null if the main class is a Vert.x launcher");
        }
        if (isLegacyVertxLauncher && !isVertxLauncher) {
            throw new IllegalArgumentException("A legacy launcher is a Vert.x launcher");
        }
        this.mainClass = mainClass;
        this.mainVerticle = mainVerticle;
        this.isVertxLauncher = isVertxLauncher;
        this.isLegacyVertxLauncher = isLegacyVertxLauncher;
    }

    public String mainClass() {
        return this.mainClass;
    }

    public String mainVerticle() {
        return this.mainVerticle;
    }

    public boolean isVertxLauncher() {
        return this.isVertxLauncher;
    }

    public boolean isLegacyVertxLauncher() {
        return this.isLegacyVertxLauncher;
    }
}

