/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.utils;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.SelectorUtils;

public class FileChangesHelper
implements AutoCloseable {
    private final Log log;
    private final FileAlterationObserver observer;
    private boolean updated;

    public FileChangesHelper(Log log, File redeployRootDirectory, List<String> redeployIncludes, List<String> redeployExcludes) throws Exception {
        this.log = log;
        this.observer = new FileAlterationObserver(redeployRootDirectory, (FileFilter)new RedeploymentFileFilter(redeployRootDirectory, redeployIncludes, redeployExcludes));
        this.observer.initialize();
        this.observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onDirectoryChange(File directory) {
                FileChangesHelper.this.onListenerEvent(directory);
            }

            public void onDirectoryCreate(File directory) {
                FileChangesHelper.this.onListenerEvent(directory);
            }

            public void onDirectoryDelete(File directory) {
                FileChangesHelper.this.onListenerEvent(directory);
            }

            public void onFileChange(File file) {
                FileChangesHelper.this.onListenerEvent(file);
            }

            public void onFileCreate(File file) {
                FileChangesHelper.this.onListenerEvent(file);
            }

            public void onFileDelete(File file) {
                FileChangesHelper.this.onListenerEvent(file);
            }
        });
    }

    private void onListenerEvent(File event) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Changed file event: " + event));
        }
        if (!this.updated) {
            this.updated = true;
        }
    }

    public boolean foundChanges() {
        this.updated = false;
        this.observer.checkAndNotify();
        return this.updated;
    }

    @Override
    public void close() throws Exception {
        this.observer.destroy();
    }

    private static class RedeploymentFileFilter
    implements FileFilter {
        final Path rootDirectoryPath;
        final List<String> includes;
        final List<String> excludes;

        RedeploymentFileFilter(File redeployRootDirectory, List<String> redeployIncludes, List<String> redeployExcludes) {
            this.rootDirectoryPath = redeployRootDirectory.toPath();
            this.includes = RedeploymentFileFilter.toAntPatterns(redeployIncludes);
            this.excludes = RedeploymentFileFilter.toAntPatterns(redeployExcludes);
        }

        private static List<String> toAntPatterns(List<String> patterns) {
            if (patterns == null || patterns.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> res = new ArrayList<String>(patterns.size());
            for (String pattern : patterns) {
                res.add("%ant[" + pattern + "]");
            }
            return res;
        }

        @Override
        public boolean accept(File pathname) {
            String relativePath = this.rootDirectoryPath.relativize(pathname.toPath()).toString();
            boolean accepted = this.includes.isEmpty();
            for (String include : this.includes) {
                if (!SelectorUtils.matchPath((String)include, (String)relativePath)) continue;
                accepted = true;
                break;
            }
            if (accepted) {
                for (String exclude : this.excludes) {
                    if (!SelectorUtils.matchPath((String)exclude, (String)relativePath)) continue;
                    accepted = false;
                    break;
                }
            }
            return accepted;
        }
    }
}

