/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.transport.local;

import io.reactivesocket.DuplexConnection;
import io.reactivesocket.Frame;
import io.reactivesocket.transport.TransportClient;
import io.reactivesocket.transport.local.LocalDuplexConnection;
import io.reactivesocket.transport.local.LocalServer;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.UnicastProcessor;

public class LocalClient
implements TransportClient {
    private final String name;

    private LocalClient(String name) {
        this.name = name;
    }

    public static LocalClient create(String name) {
        return new LocalClient(name);
    }

    public Mono<DuplexConnection> connect() {
        return Mono.defer(() -> {
            LocalServer.StartServerImpl server = LocalServer.findServer(this.name);
            if (server != null) {
                UnicastProcessor in = UnicastProcessor.create();
                UnicastProcessor out = UnicastProcessor.create();
                MonoProcessor closeNotifier = MonoProcessor.create();
                server.accept(new LocalDuplexConnection((Flux<Frame>)out, (Subscriber<Frame>)in, (MonoProcessor<Void>)closeNotifier));
                LocalDuplexConnection client = new LocalDuplexConnection((Flux<Frame>)in, (Subscriber<Frame>)out, (MonoProcessor<Void>)closeNotifier);
                return Mono.just((Object)client);
            }
            return Mono.error((Throwable)new IllegalArgumentException("Could not find server: " + this.name));
        });
    }
}

