/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.transport.local;

import io.reactivesocket.DuplexConnection;
import io.reactivesocket.transport.TransportServer;
import io.reactivesocket.transport.local.LocalSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import reactor.core.publisher.MonoProcessor;

public class LocalServer
implements TransportServer {
    private static final ConcurrentMap<String, StartServerImpl> registry = new ConcurrentHashMap<String, StartServerImpl>();
    private final String name;

    static StartServerImpl findServer(String name) {
        return (StartServerImpl)registry.get(name);
    }

    private LocalServer(String name) {
        this.name = name;
    }

    public static LocalServer create(String name) {
        return new LocalServer(name);
    }

    public TransportServer.StartedServer start(TransportServer.ConnectionAcceptor acceptor) {
        StartServerImpl startedServer = new StartServerImpl(this.name, acceptor);
        if (registry.putIfAbsent(this.name, startedServer) != null) {
            throw new IllegalStateException("name already registered: " + this.name);
        }
        return startedServer;
    }

    static class StartServerImpl
    implements TransportServer.StartedServer,
    Consumer<DuplexConnection> {
        private final LocalSocketAddress address;
        private final TransportServer.ConnectionAcceptor acceptor;
        private final MonoProcessor<Void> closeNotifier = MonoProcessor.create();

        public StartServerImpl(String name, TransportServer.ConnectionAcceptor acceptor) {
            this.address = new LocalSocketAddress(name);
            this.acceptor = acceptor;
        }

        @Override
        public void accept(DuplexConnection duplexConnection) {
            this.acceptor.apply(duplexConnection).subscribe();
        }

        public SocketAddress getServerAddress() {
            return this.address;
        }

        public int getServerPort() {
            return 0;
        }

        public void awaitShutdown() {
            this.closeNotifier.block();
        }

        public void awaitShutdown(long duration, TimeUnit durationUnit) {
            this.closeNotifier.blockMillis(TimeUnit.MILLISECONDS.convert(duration, durationUnit));
        }

        public void shutdown() {
            if (!registry.remove(this.address.getName(), this)) {
                throw new AssertionError();
            }
            this.closeNotifier.onComplete();
        }
    }
}

