/*
 * Decompiled with CFR 0.152.
 */
package rx.android.schedulers;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.android.plugins.RxAndroidPlugins;
import rx.android.plugins.RxAndroidSchedulersHook;
import rx.exceptions.OnErrorNotImplementedException;
import rx.functions.Action0;
import rx.plugins.RxJavaPlugins;
import rx.subscriptions.Subscriptions;

class LooperScheduler
extends Scheduler {
    private final Handler handler;

    LooperScheduler(Looper looper) {
        this.handler = new Handler(looper);
    }

    LooperScheduler(Handler handler) {
        this.handler = handler;
    }

    public Scheduler.Worker createWorker() {
        return new HandlerWorker(this.handler);
    }

    static final class ScheduledAction
    implements Runnable,
    Subscription {
        private final Action0 action;
        private final Handler handler;
        private volatile boolean unsubscribed;

        ScheduledAction(Action0 action, Handler handler) {
            this.action = action;
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                this.action.call();
            }
            catch (Throwable e) {
                IllegalStateException ie = e instanceof OnErrorNotImplementedException ? new IllegalStateException("Exception thrown on Scheduler.Worker thread. Add `onError` handling.", e) : new IllegalStateException("Fatal Exception thrown on Scheduler.Worker thread.", e);
                RxJavaPlugins.getInstance().getErrorHandler().handleError((Throwable)ie);
                Thread thread = Thread.currentThread();
                thread.getUncaughtExceptionHandler().uncaughtException(thread, ie);
            }
        }

        public void unsubscribe() {
            this.unsubscribed = true;
            this.handler.removeCallbacks((Runnable)this);
        }

        public boolean isUnsubscribed() {
            return this.unsubscribed;
        }
    }

    static class HandlerWorker
    extends Scheduler.Worker {
        private final Handler handler;
        private final RxAndroidSchedulersHook hook;
        private volatile boolean unsubscribed;

        HandlerWorker(Handler handler) {
            this.handler = handler;
            this.hook = RxAndroidPlugins.getInstance().getSchedulersHook();
        }

        public void unsubscribe() {
            this.unsubscribed = true;
            this.handler.removeCallbacksAndMessages((Object)this);
        }

        public boolean isUnsubscribed() {
            return this.unsubscribed;
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            if (this.unsubscribed) {
                return Subscriptions.unsubscribed();
            }
            action = this.hook.onSchedule(action);
            ScheduledAction scheduledAction = new ScheduledAction(action, this.handler);
            Message message = Message.obtain((Handler)this.handler, (Runnable)scheduledAction);
            message.obj = this;
            this.handler.sendMessageDelayed(message, unit.toMillis(delayTime));
            if (this.unsubscribed) {
                this.handler.removeCallbacks((Runnable)scheduledAction);
                return Subscriptions.unsubscribed();
            }
            return scheduledAction;
        }

        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, TimeUnit.MILLISECONDS);
        }
    }
}

