/*
 * Decompiled with CFR 0.152.
 */
package rx.plugins;

import java.util.concurrent.atomic.AtomicLong;
import rx.plugins.DebugNotification;

public class SimpleContext<T>
implements Comparable<SimpleContext<T>> {
    private final DebugNotification<T> notification;
    private final long threadId = Thread.currentThread().getId();
    private final long start = System.nanoTime();
    private AtomicLong end = new AtomicLong(-1L);
    private volatile Throwable err;

    public SimpleContext(DebugNotification<T> notification) {
        this.notification = notification;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        this.toString(str);
        return str.toString();
    }

    private void toString(StringBuilder str) {
        str.append("{");
        long e = this.end.get();
        if (e != -1L) {
            str.append("\"ns_duration\": ").append(String.format("%10d", e - this.start)).append(", ");
        }
        str.append("\"threadId\": ").append(String.format("%3d", this.threadId)).append(", ");
        str.append("\"notification\": ").append(this.notification).append("}");
    }

    @Override
    public int compareTo(SimpleContext<T> o) {
        return Long.compare(this.start, o.start);
    }

    public long getEnd() {
        return this.end.get();
    }

    public void setEnd() {
        if (!this.end.compareAndSet(-1L, System.nanoTime())) {
            throw new IllegalStateException("The context was already completed");
        }
    }

    public Throwable getError() {
        return this.err;
    }

    public void setError(Throwable err) {
        if (!this.end.compareAndSet(-1L, System.nanoTime())) {
            throw new IllegalStateException("The context was already completed");
        }
        this.err = err;
    }

    public DebugNotification<T> getNotification() {
        return this.notification;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public long getStart() {
        return this.start;
    }
}

