/*
 * Decompiled with CFR 0.152.
 */
package rx.observable;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.internal.producers.SingleDelayedProducer;

public class ListenableFutureObservable {
    public static <T> Observable<T> from(ListenableFuture<T> future, Scheduler scheduler) {
        final Scheduler.Worker worker = scheduler.createWorker();
        return ListenableFutureObservable.from(future, new Executor(){

            @Override
            public void execute(final Runnable command) {
                worker.schedule(new Action0(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void call() {
                        try {
                            command.run();
                        }
                        finally {
                            worker.unsubscribe();
                        }
                    }
                });
            }
        });
    }

    public static <T> Observable<T> from(final ListenableFuture<T> future, final Executor executor) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(final Subscriber<? super T> subscriber) {
                final SingleDelayedProducer sdp = new SingleDelayedProducer(subscriber);
                subscriber.setProducer((Producer)sdp);
                future.addListener(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Object t = future.get();
                            sdp.setValue(t);
                        }
                        catch (Exception e) {
                            subscriber.onError((Throwable)e);
                        }
                    }
                }, executor);
            }
        });
    }

    public static <T> ListenableFuture<T> to(Observable<T> observable) {
        class ListenFutureSubscriberAdaptor
        extends AbstractFuture<T> {
            final Subscriber<? super T> subscriber = new Subscriber<T>(){
                private T value;

                public void onCompleted() {
                    this.set(this.value);
                }

                public void onError(Throwable e) {
                    this.setException(e);
                }

                public void onNext(T t) {
                    this.value = t;
                }
            };

            ListenFutureSubscriberAdaptor() {
            }

            protected void interruptTask() {
                this.subscriber.unsubscribe();
            }
        }
        ListenFutureSubscriberAdaptor future = new ListenFutureSubscriberAdaptor();
        observable.single().subscribe(future.subscriber);
        return future;
    }
}

