/*
 * Decompiled with CFR 0.152.
 */
package rx.math.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class OperatorAverageInteger<T>
implements Observable.Operator<Integer, T> {
    final Func1<? super T, Integer> valueExtractor;

    public OperatorAverageInteger(Func1<? super T, Integer> valueExtractor) {
        this.valueExtractor = valueExtractor;
    }

    public Subscriber<? super T> call(Subscriber<? super Integer> t1) {
        return new AverageObserver(t1);
    }

    private final class AverageObserver
    extends Subscriber<T> {
        final Subscriber<? super Integer> child;
        int sum;
        int count;

        public AverageObserver(Subscriber<? super Integer> subscriber) {
            super(subscriber);
            this.child = subscriber;
        }

        public void onNext(T args) {
            this.sum += ((Integer)OperatorAverageInteger.this.valueExtractor.call(args)).intValue();
            ++this.count;
        }

        public void onError(Throwable e) {
            this.child.onError(e);
        }

        public void onCompleted() {
            if (this.count > 0) {
                try {
                    this.child.onNext((Object)(this.sum / this.count));
                }
                catch (Throwable t) {
                    this.child.onError(t);
                    return;
                }
                this.child.onCompleted();
            } else {
                this.child.onError((Throwable)new IllegalArgumentException("Sequence contains no elements"));
            }
        }
    }
}

