/*
 * Decompiled with CFR 0.152.
 */
package rx;

import org.reactivestreams.Publisher;
import rx.Completable;
import rx.Observable;
import rx.Single;
import rx.Subscriber;
import rx.internal.reactivestreams.CompletableAsPublisher;
import rx.internal.reactivestreams.PublisherAdapter;
import rx.internal.reactivestreams.PublisherAsCompletable;
import rx.internal.reactivestreams.PublisherAsSingle;
import rx.internal.reactivestreams.SingleAsPublisher;
import rx.internal.reactivestreams.SubscriberAdapter;

public abstract class RxReactiveStreams {
    private RxReactiveStreams() {
    }

    public static <T> Publisher<T> toPublisher(Observable<T> observable) {
        return new PublisherAdapter<T>(observable);
    }

    public static <T> Observable<T> toObservable(final Publisher<T> publisher) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> rxSubscriber) {
                publisher.subscribe(RxReactiveStreams.toSubscriber(rxSubscriber));
            }
        });
    }

    public static <T> org.reactivestreams.Subscriber<T> toSubscriber(Subscriber<T> rxSubscriber) {
        return new SubscriberAdapter<T>(rxSubscriber);
    }

    public static <T> Publisher<T> toPublisher(Completable completable) {
        if (completable == null) {
            throw new NullPointerException("completable");
        }
        return new CompletableAsPublisher(completable);
    }

    public static Completable toCompletable(Publisher<?> publisher) {
        if (publisher == null) {
            throw new NullPointerException("publisher");
        }
        return Completable.create((Completable.CompletableOnSubscribe)new PublisherAsCompletable(publisher));
    }

    public static <T> Publisher<T> toPublisher(Single<T> single) {
        if (single == null) {
            throw new NullPointerException("single");
        }
        return new SingleAsPublisher<T>(single);
    }

    public static <T> Single<T> toSingle(Publisher<T> publisher) {
        if (publisher == null) {
            throw new NullPointerException("publisher");
        }
        return Single.create(new PublisherAsSingle<T>(publisher));
    }
}

