/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.internal.operators.NotificationLite;
import rx.observers.Subscribers;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;

public class BufferUntilSubscriber<T>
extends Subject<T, T> {
    final State<T> state;

    public static <T> BufferUntilSubscriber<T> create() {
        State state = new State();
        return new BufferUntilSubscriber(state);
    }

    private BufferUntilSubscriber(State<T> state) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
    }

    @Override
    public void onCompleted() {
        this.state.observerRef.onCompleted();
    }

    @Override
    public void onError(Throwable e) {
        this.state.observerRef.onError(e);
    }

    @Override
    public void onNext(T t) {
        this.state.observerRef.onNext(t);
    }

    private static final class BufferedObserver<T>
    extends Subscriber<T> {
        private final ConcurrentLinkedQueue<Object> buffer = new ConcurrentLinkedQueue();
        private static final NotificationLite<Object> nl = NotificationLite.instance();

        private BufferedObserver() {
        }

        @Override
        public void onCompleted() {
            this.buffer.add(nl.completed());
        }

        @Override
        public void onError(Throwable e) {
            this.buffer.add(nl.error(e));
        }

        @Override
        public void onNext(T t) {
            this.buffer.add(nl.next(t));
        }
    }

    private static final class PassThruObserver<T>
    extends Subscriber<T> {
        private final Observer<? super T> actual;
        private final ConcurrentLinkedQueue<Object> buffer;
        private final State<T> state;

        PassThruObserver(Observer<? super T> actual, ConcurrentLinkedQueue<Object> buffer, State<T> state) {
            this.actual = actual;
            this.buffer = buffer;
            this.state = state;
        }

        @Override
        public void onCompleted() {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onNext(t);
        }

        private void drainIfNeededAndSwitchToActual() {
            Object o;
            NotificationLite nl = NotificationLite.instance();
            while ((o = this.buffer.poll()) != null) {
                nl.accept(this, o);
            }
            this.state.setObserverRef(this.actual);
        }
    }

    static final class OnSubscribeAction<T>
    implements Observable.OnSubscribe<T> {
        final State<T> state;

        public OnSubscribeAction(State<T> state) {
            this.state = state;
        }

        @Override
        public void call(Subscriber<? super T> s) {
            if (this.state.casFirst(0, 1)) {
                Object o;
                NotificationLite<? super T> nl = NotificationLite.instance();
                BufferedObserver buffered = (BufferedObserver)this.state.observerRef;
                while ((o = buffered.buffer.poll()) != null) {
                    nl.accept(s, o);
                }
                this.state.setObserverRef(new PassThruObserver<T>(s, buffered.buffer, this.state));
                s.add(Subscriptions.create(new Action0(){

                    @Override
                    public void call() {
                        OnSubscribeAction.this.state.setObserverRef(Subscribers.empty());
                    }
                }));
            } else {
                s.onError(new IllegalStateException("Only one subscriber allowed!"));
            }
        }
    }

    static final class State<T> {
        volatile Observer<? super T> observerRef = new BufferedObserver<T>();
        volatile int first;
        static final AtomicReferenceFieldUpdater<State, Observer> OBSERVER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(State.class, Observer.class, "observerRef");
        static final AtomicIntegerFieldUpdater<State> FIRST_UPDATER = AtomicIntegerFieldUpdater.newUpdater(State.class, "first");

        State() {
        }

        boolean casFirst(int expected, int next) {
            return FIRST_UPDATER.compareAndSet(this, expected, next);
        }

        void setObserverRef(Observer<? super T> o) {
            this.observerRef = o;
        }
    }
}

