/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public final class OnSubscribeRange
implements Observable.OnSubscribe<Integer> {
    private final int start;
    private final int end;

    public OnSubscribeRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public void call(Subscriber<? super Integer> o) {
        o.setProducer(new RangeProducer(o, this.start, this.end));
    }

    private static final class RangeProducer
    implements Producer {
        private final Subscriber<? super Integer> o;
        private volatile long requested;
        private static final AtomicLongFieldUpdater<RangeProducer> REQUESTED_UPDATER = AtomicLongFieldUpdater.newUpdater(RangeProducer.class, "requested");
        private long index;
        private final int end;

        private RangeProducer(Subscriber<? super Integer> o, int start, int end) {
            this.o = o;
            this.index = start;
            this.end = end;
        }

        @Override
        public void request(long n) {
            long _c;
            if (REQUESTED_UPDATER.get(this) == Long.MAX_VALUE) {
                return;
            }
            if (n == Long.MAX_VALUE) {
                REQUESTED_UPDATER.set(this, n);
                for (long i = this.index; i <= (long)this.end; ++i) {
                    if (this.o.isUnsubscribed()) {
                        return;
                    }
                    this.o.onNext((Integer)((int)i));
                }
                if (!this.o.isUnsubscribed()) {
                    this.o.onCompleted();
                }
            } else if (n > 0L && (_c = REQUESTED_UPDATER.getAndAdd(this, n)) == 0L) {
                long e;
                do {
                    long r = this.requested;
                    long idx = this.index;
                    long numLeft = (long)this.end - idx + 1L;
                    e = Math.min(numLeft, r);
                    boolean completeOnFinish = numLeft <= r;
                    long stopAt = e + idx;
                    for (long i = idx; i < stopAt; ++i) {
                        if (this.o.isUnsubscribed()) {
                            return;
                        }
                        this.o.onNext((Integer)((int)i));
                    }
                    this.index = stopAt;
                    if (!completeOnFinish) continue;
                    this.o.onCompleted();
                    return;
                } while (REQUESTED_UPDATER.addAndGet(this, -e) != 0L);
                return;
            }
        }
    }
}

