/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Actions;
import rx.subscriptions.CompositeSubscription;

public final class Subscriptions {
    private static final Empty EMPTY = new Empty();

    public static Subscription empty() {
        return EMPTY;
    }

    public static Subscription create(Action0 unsubscribe) {
        return new ActionSubscription(unsubscribe);
    }

    public static Subscription from(Future<?> f) {
        return new FutureSubscription(f);
    }

    public static CompositeSubscription from(Subscription ... subscriptions) {
        return new CompositeSubscription(subscriptions);
    }

    private static final class Empty
    implements Subscription {
        private Empty() {
        }

        @Override
        public void unsubscribe() {
        }

        @Override
        public boolean isUnsubscribed() {
            return false;
        }
    }

    private static final class FutureSubscription
    implements Subscription {
        final Future<?> f;

        public FutureSubscription(Future<?> f) {
            this.f = f;
        }

        @Override
        public void unsubscribe() {
            this.f.cancel(true);
        }

        @Override
        public boolean isUnsubscribed() {
            return this.f.isCancelled();
        }
    }

    private static final class ActionSubscription
    implements Subscription {
        volatile Action0 actual;
        static final AtomicReferenceFieldUpdater<ActionSubscription, Action0> ACTUAL_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ActionSubscription.class, Action0.class, "actual");
        private static final Unsubscribed UNSUBSCRIBED_ACTION = new Unsubscribed();

        public ActionSubscription(Action0 action) {
            this.actual = action != null ? action : Actions.empty();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.actual == UNSUBSCRIBED_ACTION;
        }

        @Override
        public void unsubscribe() {
            Action0 a = ACTUAL_UPDATER.getAndSet(this, UNSUBSCRIBED_ACTION);
            a.call();
        }

        private static final class Unsubscribed
        implements Action0 {
            private Unsubscribed() {
            }

            @Override
            public void call() {
            }
        }
    }
}

