/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.observables.ConnectableObservable;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;

public final class OperatorMulticast<T, R>
extends ConnectableObservable<R> {
    final Observable<? extends T> source;
    final Object guard;
    final Func0<? extends Subject<? super T, ? extends R>> subjectFactory;
    private final AtomicReference<Subject<? super T, ? extends R>> connectedSubject;
    private final List<Subscriber<? super R>> waitingForConnect;
    Subscriber<T> subscription;

    public OperatorMulticast(Observable<? extends T> source, Func0<? extends Subject<? super T, ? extends R>> subjectFactory) {
        this(new Object(), new AtomicReference<Subject<? super T, ? extends R>>(), new ArrayList<Subscriber<? super R>>(), source, subjectFactory);
    }

    private OperatorMulticast(final Object guard, final AtomicReference<Subject<? super T, ? extends R>> connectedSubject, final List<Subscriber<? super R>> waitingForConnect, Observable<? extends T> source, Func0<? extends Subject<? super T, ? extends R>> subjectFactory) {
        super(new Observable.OnSubscribe<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(Subscriber<? super R> subscriber) {
                Object object = guard;
                synchronized (object) {
                    if (connectedSubject.get() == null) {
                        waitingForConnect.add(subscriber);
                    } else {
                        ((Subject)connectedSubject.get()).unsafeSubscribe(subscriber);
                    }
                }
            }
        });
        this.guard = guard;
        this.connectedSubject = connectedSubject;
        this.waitingForConnect = waitingForConnect;
        this.source = source;
        this.subjectFactory = subjectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Action1<? super Subscription> connection) {
        boolean shouldSubscribe = false;
        Object object = this.guard;
        synchronized (object) {
            if (this.subscription != null) {
                return;
            }
            shouldSubscribe = true;
            final Subject<? super R, R> subject = this.subjectFactory.call();
            this.subscription = new Subscriber<T>(){

                @Override
                public void onCompleted() {
                    subject.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    subject.onError(e);
                }

                @Override
                public void onNext(T args) {
                    subject.onNext(args);
                }
            };
            for (Subscriber<? super R> subscriber : this.waitingForConnect) {
                subject.unsafeSubscribe(subscriber);
            }
            this.waitingForConnect.clear();
            this.connectedSubject.set(subject);
        }
        if (shouldSubscribe) {
            connection.call(Subscriptions.create(new Action0(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void call() {
                    Subscriber s;
                    Object object = OperatorMulticast.this.guard;
                    synchronized (object) {
                        s = OperatorMulticast.this.subscription;
                        OperatorMulticast.this.subscription = null;
                        OperatorMulticast.this.connectedSubject.set(null);
                    }
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
            }));
            this.source.unsafeSubscribe(this.subscription);
        }
    }
}

