/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Deque;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;

final class TakeLastQueueProducer<T>
implements Producer {
    private final NotificationLite<T> notification;
    private final Deque<Object> deque;
    private final Subscriber<? super T> subscriber;
    private volatile boolean emittingStarted = false;
    private volatile long requested = 0L;
    private static final AtomicLongFieldUpdater<TakeLastQueueProducer> REQUESTED_UPDATER = AtomicLongFieldUpdater.newUpdater(TakeLastQueueProducer.class, "requested");

    public TakeLastQueueProducer(NotificationLite<T> n, Deque<Object> q, Subscriber<? super T> subscriber) {
        this.notification = n;
        this.deque = q;
        this.subscriber = subscriber;
    }

    void startEmitting() {
        if (!this.emittingStarted) {
            this.emittingStarted = true;
            this.emit(0L);
        }
    }

    @Override
    public void request(long n) {
        if (this.requested == Long.MAX_VALUE) {
            return;
        }
        long _c = n == Long.MAX_VALUE ? REQUESTED_UPDATER.getAndSet(this, Long.MAX_VALUE) : REQUESTED_UPDATER.getAndAdd(this, n);
        if (!this.emittingStarted) {
            return;
        }
        this.emit(_c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emit(long previousRequested) {
        if (this.requested == Long.MAX_VALUE) {
            if (previousRequested == 0L) {
                try {
                    for (Object value : this.deque) {
                        this.notification.accept(this.subscriber, value);
                    }
                }
                catch (Throwable e) {
                    this.subscriber.onError(e);
                }
                finally {
                    this.deque.clear();
                }
            }
        } else if (previousRequested == 0L) {
            block6: while (true) {
                long newRequested;
                long oldRequested;
                Object o;
                long numToEmit = this.requested;
                int emitted = 0;
                while (--numToEmit >= 0L && (o = this.deque.poll()) != null) {
                    if (this.subscriber.isUnsubscribed()) {
                        return;
                    }
                    if (this.notification.accept(this.subscriber, o)) {
                        return;
                    }
                    ++emitted;
                }
                do {
                    oldRequested = this.requested;
                    newRequested = oldRequested - (long)emitted;
                    if (oldRequested == Long.MAX_VALUE) continue block6;
                } while (!REQUESTED_UPDATER.compareAndSet(this, oldRequested, newRequested));
                if (newRequested == 0L) break;
            }
            return;
        }
    }
}

