/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Action0;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.schedulers.ImmediateScheduler;
import rx.schedulers.TrampolineScheduler;

public final class OperatorObserveOn<T>
implements Observable.Operator<T, T> {
    private final Scheduler scheduler;

    public OperatorObserveOn(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        if (this.scheduler instanceof ImmediateScheduler) {
            return child;
        }
        if (this.scheduler instanceof TrampolineScheduler) {
            return child;
        }
        return new ObserveOnSubscriber<T>(this.scheduler, child);
    }

    static final class ScheduledUnsubscribe
    implements Subscription {
        final Scheduler.Worker worker;
        volatile int once;
        static final AtomicIntegerFieldUpdater<ScheduledUnsubscribe> ONCE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ScheduledUnsubscribe.class, "once");
        final RxRingBuffer queue;
        volatile boolean unsubscribed = false;

        public ScheduledUnsubscribe(Scheduler.Worker worker, RxRingBuffer queue) {
            this.worker = worker;
            this.queue = queue;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.unsubscribed;
        }

        @Override
        public void unsubscribe() {
            if (ONCE_UPDATER.getAndSet(this, 1) == 0) {
                this.worker.schedule(new Action0(){

                    @Override
                    public void call() {
                        ScheduledUnsubscribe.this.worker.unsubscribe();
                        ScheduledUnsubscribe.this.unsubscribed = true;
                    }
                });
            }
        }
    }

    private static final class ObserveOnSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> child;
        private final Scheduler.Worker recursiveScheduler;
        private final ScheduledUnsubscribe scheduledUnsubscribe;
        final NotificationLite<T> on = NotificationLite.instance();
        private final RxRingBuffer queue = RxRingBuffer.getSpscInstance();
        private boolean completed = false;
        private boolean failure = false;
        private volatile long requested = 0L;
        static final AtomicLongFieldUpdater<ObserveOnSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(ObserveOnSubscriber.class, "requested");
        volatile long counter;
        static final AtomicLongFieldUpdater<ObserveOnSubscriber> COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(ObserveOnSubscriber.class, "counter");

        public ObserveOnSubscriber(Scheduler scheduler, Subscriber<? super T> child) {
            this.child = child;
            this.recursiveScheduler = scheduler.createWorker();
            this.scheduledUnsubscribe = new ScheduledUnsubscribe(this.recursiveScheduler, this.queue);
            child.add(this.scheduledUnsubscribe);
            child.setProducer(new Producer(){

                @Override
                public void request(long n) {
                    REQUESTED.getAndAdd(ObserveOnSubscriber.this, n);
                    ObserveOnSubscriber.this.schedule();
                }
            });
            child.add(this.recursiveScheduler);
            child.add(this);
        }

        @Override
        public void onStart() {
            this.request(RxRingBuffer.SIZE);
        }

        @Override
        public void onNext(T t) {
            if (this.isUnsubscribed() || this.completed) {
                return;
            }
            try {
                this.queue.onNext(t);
            }
            catch (MissingBackpressureException e) {
                this.onError(e);
                return;
            }
            this.schedule();
        }

        @Override
        public void onCompleted() {
            if (this.isUnsubscribed() || this.completed) {
                return;
            }
            this.completed = true;
            this.queue.onCompleted();
            this.schedule();
        }

        @Override
        public void onError(Throwable e) {
            if (this.isUnsubscribed() || this.completed) {
                return;
            }
            this.unsubscribe();
            this.completed = true;
            this.failure = true;
            this.queue.onError(e);
            this.schedule();
        }

        protected void schedule() {
            if (COUNTER_UPDATER.getAndIncrement(this) == 0L) {
                this.recursiveScheduler.schedule(new Action0(){

                    @Override
                    public void call() {
                        ObserveOnSubscriber.this.pollQueue();
                    }
                });
            }
        }

        private void pollQueue() {
            int emitted = 0;
            block0: do {
                COUNTER_UPDATER.set(this, 1L);
                while (!this.scheduledUnsubscribe.isUnsubscribed()) {
                    Object o;
                    if (this.failure) {
                        o = this.queue.poll();
                        if (!this.on.isError(o)) continue;
                        this.on.accept(this.child, o);
                        return;
                    }
                    if (REQUESTED.getAndDecrement(this) != 0L) {
                        o = this.queue.poll();
                        if (o == null) {
                            REQUESTED.incrementAndGet(this);
                            continue block0;
                        }
                        if (this.on.accept(this.child, o)) continue;
                        ++emitted;
                        continue;
                    }
                    REQUESTED.incrementAndGet(this);
                    continue block0;
                }
            } while (COUNTER_UPDATER.decrementAndGet(this) > 0L);
            if (emitted > 0) {
                this.request(emitted);
            }
        }
    }
}

