/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import java.util.Collection;
import rx.Observable;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class AsyncSubject<T>
extends Subject<T, T> {
    final SubjectSubscriptionManager<T> state;
    volatile Object lastValue;
    private final NotificationLite<T> nl = NotificationLite.instance();

    public static <T> AsyncSubject<T> create() {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        state.onTerminated = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                Object v = state.get();
                NotificationLite nl = state.nl;
                o.accept(v, nl);
                if (v == null || !nl.isCompleted(v) && !nl.isError(v)) {
                    o.onCompleted();
                }
            }
        };
        return new AsyncSubject(state, state);
    }

    protected AsyncSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        if (this.state.active) {
            Object last = this.lastValue;
            if (last == null) {
                last = this.nl.completed();
            }
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(last)) {
                if (last == this.nl.completed()) {
                    bo.onCompleted();
                    continue;
                }
                bo.onNext(this.nl.getValue(last));
                bo.onCompleted();
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.state.active) {
            Object n = this.nl.error(e);
            ArrayList<Throwable> errors = null;
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(n)) {
                try {
                    bo.onError(e);
                }
                catch (Throwable e2) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(e2);
                }
            }
            if (errors != null) {
                if (errors.size() == 1) {
                    Exceptions.propagate((Throwable)errors.get(0));
                } else {
                    throw new CompositeException("Errors while emitting AsyncSubject.onError", (Collection<? extends Throwable>)errors);
                }
            }
        }
    }

    @Override
    public void onNext(T v) {
        this.lastValue = this.nl.next(v);
    }

    @Override
    public boolean hasObservers() {
        return this.state.observers().length > 0;
    }
}

