/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Single;
import rx.SingleSubscriber;
import rx.plugins.RxJavaHooks;

public final class SingleTakeUntilSingle<T, U>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final Single<? extends U> other;

    public SingleTakeUntilSingle(Single.OnSubscribe<T> source, Single<? extends U> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        TakeUntilSourceSubscriber parent = new TakeUntilSourceSubscriber(t);
        t.add(parent);
        this.other.subscribe(parent.other);
        this.source.call(parent);
    }

    static final class TakeUntilSourceSubscriber<T, U>
    extends SingleSubscriber<T> {
        final SingleSubscriber<? super T> actual;
        final AtomicBoolean once;
        final SingleSubscriber<U> other;

        TakeUntilSourceSubscriber(SingleSubscriber<? super T> actual) {
            this.actual = actual;
            this.once = new AtomicBoolean();
            this.other = new OtherSubscriber();
            this.add(this.other);
        }

        @Override
        public void onSuccess(T value) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable error) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onError(error);
            } else {
                RxJavaHooks.onError(error);
            }
        }

        final class OtherSubscriber
        extends SingleSubscriber<U> {
            OtherSubscriber() {
            }

            @Override
            public void onSuccess(U value) {
                this.onError(new CancellationException("Stream was canceled before emitting a terminal event."));
            }

            @Override
            public void onError(Throwable error) {
                TakeUntilSourceSubscriber.this.onError(error);
            }
        }
    }
}

