/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.operators.flowable.FlowableWithUpstream;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowablePublish<T>
extends ConnectableFlowable<T>
implements FlowableWithUpstream<T> {
    final Publisher<T> source;
    final AtomicReference<PublishSubscriber<T>> current;
    final int bufferSize;
    final Publisher<T> onSubscribe;

    public static <T> ConnectableFlowable<T> create(Flowable<T> source, final int bufferSize) {
        final AtomicReference<PublishSubscriber<T>> curr = new AtomicReference<PublishSubscriber<T>>();
        Publisher onSubscribe = new Publisher<T>(){

            public void subscribe(Subscriber<? super T> child) {
                InnerProducer inner;
                while (true) {
                    PublishSubscriber r;
                    if ((r = (PublishSubscriber)curr.get()) == null || r.isDisposed()) {
                        PublishSubscriber u = new PublishSubscriber(curr, bufferSize);
                        if (!curr.compareAndSet(r, u)) continue;
                        r = u;
                    }
                    if (r.add(inner = new InnerProducer(r, child))) break;
                }
                child.onSubscribe(inner);
            }
        };
        return RxJavaPlugins.onAssembly(new FlowablePublish<T>(onSubscribe, source, curr, bufferSize));
    }

    private FlowablePublish(Publisher<T> onSubscribe, Publisher<T> source, AtomicReference<PublishSubscriber<T>> current, int bufferSize) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
        this.bufferSize = bufferSize;
    }

    @Override
    public Publisher<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.onSubscribe.subscribe(s);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        PublishSubscriber<T> ps;
        boolean doConnect = false;
        while ((ps = this.current.get()) == null || ps.isDisposed()) {
            PublishSubscriber<T> u = new PublishSubscriber<T>(this.current, this.bufferSize);
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw Exceptions.propagate(ex);
        }
        if (doConnect) {
            this.source.subscribe(ps);
        }
    }

    static final class InnerProducer<T>
    extends AtomicLong
    implements Subscription,
    Disposable {
        private static final long serialVersionUID = -4453897557930727610L;
        final PublishSubscriber<T> parent;
        final Subscriber<? super T> child;
        static final long UNSUBSCRIBED = Long.MIN_VALUE;

        public InnerProducer(PublishSubscriber<T> parent, Subscriber<? super T> child) {
            this.parent = parent;
            this.child = child;
        }

        public void request(long n) {
            long u;
            long r;
            if (n < 0L) {
                RxJavaPlugins.onError(new IllegalArgumentException("n < 0 required but it was " + n));
                return;
            }
            do {
                if ((r = this.get()) == Long.MIN_VALUE) {
                    return;
                }
                if (r >= 0L && n == 0L) {
                    return;
                }
                if (r == 0L) {
                    u = n;
                    continue;
                }
                u = r + n;
                if (u >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.compareAndSet(r, u));
            this.parent.dispatch();
        }

        public long produced(long n) {
            long u;
            long r;
            if (n <= 0L) {
                throw new IllegalArgumentException("Cant produce zero or less");
            }
            do {
                if ((r = this.get()) == 0L) {
                    throw new IllegalStateException("Produced without request");
                }
                if (r == Long.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                u = r - n;
                if (u >= 0L) continue;
                throw new IllegalStateException("More produced (" + n + ") than requested (" + r + ")");
            } while (!this.compareAndSet(r, u));
            return u;
        }

        @Override
        public boolean isDisposed() {
            return this.get() == Long.MIN_VALUE;
        }

        public void cancel() {
            this.dispose();
        }

        @Override
        public void dispose() {
            long r = this.get();
            if (r != Long.MIN_VALUE && (r = this.getAndSet(Long.MIN_VALUE)) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.dispatch();
            }
        }
    }

    static final class PublishSubscriber<T>
    implements Subscriber<T>,
    Disposable {
        final SpscArrayQueue<Object> queue;
        final AtomicReference<PublishSubscriber<T>> current;
        final int bufferSize;
        volatile Object terminalEvent;
        static final InnerProducer[] EMPTY = new InnerProducer[0];
        static final InnerProducer[] TERMINATED = new InnerProducer[0];
        final AtomicReference<InnerProducer[]> producers;
        final AtomicBoolean shouldConnect;
        boolean emitting;
        boolean missed;
        final AtomicReference<Subscription> s = new AtomicReference();

        public PublishSubscriber(AtomicReference<PublishSubscriber<T>> current, int bufferSize) {
            this.queue = new SpscArrayQueue(bufferSize);
            this.producers = new AtomicReference<InnerProducer[]>(EMPTY);
            this.current = current;
            this.shouldConnect = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        @Override
        public void dispose() {
            InnerProducer[] ps;
            if (this.producers.get() != TERMINATED && (ps = this.producers.getAndSet(TERMINATED)) != TERMINATED) {
                this.current.compareAndSet(this, null);
                SubscriptionHelper.cancel(this.s);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.producers.get() == TERMINATED;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.s, s)) {
                s.request((long)this.bufferSize);
            }
        }

        public void onNext(T t) {
            if (!this.queue.offer((Object)t)) {
                this.onError(new IllegalStateException("Prefetch queue is full?!"));
            } else {
                this.dispatch();
            }
        }

        public void onError(Throwable e) {
            if (this.terminalEvent == null) {
                this.terminalEvent = NotificationLite.error(e);
                this.dispatch();
            }
        }

        public void onComplete() {
            if (this.terminalEvent == null) {
                this.terminalEvent = NotificationLite.complete();
                this.dispatch();
            }
        }

        boolean add(InnerProducer<T> producer) {
            InnerProducer[] u;
            InnerProducer[] c;
            if (producer == null) {
                throw new NullPointerException();
            }
            do {
                if ((c = this.producers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerProducer[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.producers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerProducer<T> producer) {
            InnerProducer[] u;
            InnerProducer[] c;
            do {
                if ((c = this.producers.get()) == EMPTY || c == TERMINATED) {
                    return;
                }
                int j = -1;
                int len = c.length;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                    continue;
                }
                u = new InnerProducer[len - 1];
                System.arraycopy(c, 0, u, 0, j);
                System.arraycopy(c, j + 1, u, j, len - j - 1);
            } while (!this.producers.compareAndSet(c, u));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkTerminated(Object term, boolean empty) {
            if (term != null) {
                if (NotificationLite.isComplete(term)) {
                    if (empty) {
                        this.current.compareAndSet(this, null);
                        try {
                            for (InnerProducer ip : this.producers.getAndSet(TERMINATED)) {
                                ip.child.onComplete();
                            }
                        }
                        finally {
                            this.dispose();
                        }
                        return true;
                    }
                } else {
                    Throwable t = NotificationLite.getError(term);
                    this.current.compareAndSet(this, null);
                    try {
                        for (InnerProducer ip : this.producers.getAndSet(TERMINATED)) {
                            ip.child.onError(t);
                        }
                    }
                    finally {
                        this.dispose();
                    }
                    return true;
                }
            }
            return false;
        }

        /*
         * Exception decompiling
         */
        void dispatch() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [29[UNCONDITIONALDOLOOP]], but top level block is 15[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

