/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableTakeUntilPredicate<T>
extends AbstractObservableWithUpstream<T, T> {
    final Predicate<? super T> predicate;

    public ObservableTakeUntilPredicate(ObservableSource<T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        this.source.subscribe(new TakeUntilPredicateSubscriber<T>(s, this.predicate));
    }

    static final class TakeUntilPredicateSubscriber<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        final Predicate<? super T> predicate;
        Disposable s;
        boolean done;

        public TakeUntilPredicateSubscriber(Observer<? super T> actual, Predicate<? super T> predicate) {
            this.actual = actual;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (!this.done) {
                boolean b;
                this.actual.onNext(t);
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.s.dispose();
                    this.onError(e);
                    return;
                }
                if (b) {
                    this.done = true;
                    this.s.dispose();
                    this.actual.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.done) {
                this.done = true;
                this.actual.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.actual.onComplete();
            }
        }
    }
}

