/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableUnsubscribeOn<T>
extends AbstractObservableWithUpstream<T, T> {
    final Scheduler scheduler;

    public ObservableUnsubscribeOn(ObservableSource<T> source, Scheduler scheduler) {
        super(source);
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new UnsubscribeSubscriber<T>(t, this.scheduler));
    }

    static final class UnsubscribeSubscriber<T>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 1015244841293359600L;
        final Observer<? super T> actual;
        final Scheduler scheduler;
        Disposable s;

        public UnsubscribeSubscriber(Observer<? super T> actual, Scheduler scheduler) {
            this.actual = actual;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.scheduler.scheduleDirect(new Runnable(){

                    @Override
                    public void run() {
                        UnsubscribeSubscriber.this.s.dispose();
                    }
                });
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }
    }
}

