/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class RxThreadFactory
extends AtomicLong
implements ThreadFactory {
    private static final long serialVersionUID = -7789753024099756196L;
    final String prefix;
    static volatile boolean CREATE_TRACE;

    public RxThreadFactory(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        StringBuilder nameBuilder = new StringBuilder(this.prefix).append('-').append(this.incrementAndGet());
        if (CREATE_TRACE) {
            nameBuilder.append("\r\n");
            for (StackTraceElement se : Thread.currentThread().getStackTrace()) {
                String s = se.toString();
                if (s.contains("sun.reflect.") || s.contains("junit.runners.") || s.contains("org.gradle.internal.") || s.contains("java.util.concurrent.ThreadPoolExecutor")) continue;
                nameBuilder.append(s).append("\r\n");
            }
        }
        Thread t = new Thread(r, nameBuilder.toString());
        t.setDaemon(true);
        return t;
    }

    @Override
    public String toString() {
        return "RxThreadFactory[" + this.prefix + "]";
    }
}

