/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.observable;

import io.reactivex.Notification;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;

public final class ToNotificationObserver<T>
implements Observer<T> {
    final Consumer<? super Notification<Object>> consumer;
    Disposable s;

    public ToNotificationObserver(Consumer<? super Notification<Object>> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void onSubscribe(Disposable s) {
        if (DisposableHelper.validate(this.s, s)) {
            this.s = s;
        }
    }

    @Override
    public void onNext(T t) {
        if (t == null) {
            this.s.dispose();
            this.onError(new NullPointerException());
        } else {
            try {
                this.consumer.accept(Notification.createOnNext(t));
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.s.dispose();
                this.onError(ex);
            }
        }
    }

    @Override
    public void onError(Throwable t) {
        try {
            this.consumer.accept(Notification.createOnError(t));
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(ex);
        }
    }

    @Override
    public void onComplete() {
        try {
            this.consumer.accept(Notification.createOnComplete());
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(ex);
        }
    }
}

