/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.functions.IntFunction;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class AsyncProcessor<T>
extends FlowableProcessor<T> {
    final State<T> state = new State();
    boolean done;
    private static final Object[] EMPTY = new Object[0];

    public static <T> AsyncProcessor<T> create() {
        return new AsyncProcessor<T>();
    }

    protected AsyncProcessor() {
    }

    public void onSubscribe(Subscription s) {
        if (this.done) {
            s.cancel();
            return;
        }
        s.request(Long.MAX_VALUE);
    }

    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (t == null) {
            this.onError(new NullPointerException());
            return;
        }
        this.state.lazySet(t);
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        if (t == null) {
            t = new NullPointerException();
        }
        this.done = true;
        this.state.lazySet(NotificationLite.error(t));
        for (AsyncSubscription<T> as : this.state.terminate()) {
            as.setError(t);
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Object value = this.state.get();
        for (AsyncSubscription asyncSubscription : this.state.terminate()) {
            asyncSubscription.setValue(value);
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.state.subscribers().length != 0;
    }

    public boolean hasValue() {
        Object o = this.state.get();
        return o != null && !NotificationLite.isError(o);
    }

    @Override
    public boolean hasComplete() {
        Object o = this.state.get();
        return this.state.subscribers() == State.TERMINATED && !NotificationLite.isError(o);
    }

    @Override
    public boolean hasThrowable() {
        return NotificationLite.isError(this.state.get());
    }

    @Override
    public Throwable getThrowable() {
        Object o = this.state.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    public T getValue() {
        Object o = this.state.get();
        if (o != null && !NotificationLite.isError(o)) {
            return (T)o;
        }
        return null;
    }

    public Object[] getValues() {
        Object[] a = EMPTY;
        Object[] b = this.getValues(a);
        if (b == EMPTY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        Object o = this.state.get();
        if (o != null && !NotificationLite.isError(o) && !NotificationLite.isComplete(o)) {
            int n = array.length;
            if (n == 0) {
                array = Arrays.copyOf(array, 1);
            }
            array[0] = o;
            if (array.length > 1) {
                array[1] = null;
            }
        } else if (array.length != 0) {
            array[0] = null;
        }
        return array;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.state.subscribe(s);
    }

    static final class AsyncSubscription<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 2900823026377918858L;
        final Subscriber<? super T> actual;
        final State<T> state;
        static final int NO_REQUEST_NO_VALUE = 0;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;

        public AsyncSubscription(Subscriber<? super T> actual, State<T> state) {
            this.actual = actual;
            this.state = state;
        }

        public void setValue(T value) {
            int s;
            while ((s = this.get()) != 1 && s != 3) {
                if (s == 0) {
                    if (!this.compareAndSet(0, 1)) continue;
                    return;
                }
                if (s != 2) continue;
                this.lazySet(3);
                if (value != null) {
                    this.actual.onNext(value);
                }
                this.actual.onComplete();
            }
            return;
        }

        public void setError(Throwable e) {
            int s = this.get();
            if (s != 3 && (s = this.getAndSet(3)) != 3) {
                this.actual.onError(e);
            }
        }

        public void request(long n) {
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            while (true) {
                int s;
                if ((s = this.get()) == 2 || s == 3) {
                    return;
                }
                if (s == 0) {
                    if (!this.compareAndSet(0, 2)) continue;
                    return;
                }
                if (this.compareAndSet(1, 3)) break;
            }
            Object v = this.state.get();
            if (v != null) {
                this.actual.onNext(v);
            }
            this.actual.onComplete();
        }

        public void cancel() {
            int s = this.get();
            if (s != 3 && (s = this.getAndSet(3)) != 3) {
                this.state.remove(this);
            }
        }

        boolean isDone() {
            return this.get() == 3;
        }
    }

    static final class State<T>
    extends AtomicReference<Object>
    implements Publisher<T>,
    IntFunction<AsyncSubscription<T>[]> {
        private static final long serialVersionUID = 2983503212425065796L;
        static final AsyncSubscription[] EMPTY = new AsyncSubscription[0];
        static final AsyncSubscription[] TERMINATED = new AsyncSubscription[0];
        final AtomicReference<AsyncSubscription<T>[]> subscribers = new AtomicReference<AsyncSubscription[]>(EMPTY);

        State() {
        }

        public AsyncSubscription<T>[] subscribers() {
            return this.subscribers.get();
        }

        public AsyncSubscription<T>[] terminate() {
            AsyncSubscription<T>[] a = this.subscribers.get();
            if (a != TERMINATED) {
                a = this.subscribers.getAndSet(TERMINATED);
            }
            return a;
        }

        boolean add(AsyncSubscription<T> as) {
            AsyncSubscription<T>[] b;
            AsyncSubscription<T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = this.apply(n + 1);
                System.arraycopy(a, 0, b, 0, n);
                b[n] = as;
            } while (!this.subscribers.compareAndSet(a, b));
            return true;
        }

        void remove(AsyncSubscription<T> as) {
            AsyncSubscription[] b;
            AsyncSubscription<T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                    return;
                }
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != as) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = this.apply(n - 1);
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        @Override
        public AsyncSubscription<T>[] apply(int value) {
            return new AsyncSubscription[value];
        }

        public void subscribe(Subscriber<? super T> t) {
            AsyncSubscription as = new AsyncSubscription(t, this);
            t.onSubscribe(as);
            if (this.add(as)) {
                if (as.isDone()) {
                    this.remove(as);
                }
            } else {
                Object o = this.get();
                if (NotificationLite.isError(o)) {
                    as.setError(NotificationLite.getError(o));
                } else {
                    as.setValue(o);
                }
            }
        }
    }
}

