/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableElementAt<T>
extends AbstractObservableWithUpstream<T, T> {
    final long index;
    final T defaultValue;

    public ObservableElementAt(ObservableSource<T> source, long index, T defaultValue) {
        super(source);
        this.index = index;
        this.defaultValue = defaultValue;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new ElementAtSubscriber<T>(t, this.index, this.defaultValue));
    }

    static final class ElementAtSubscriber<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        final long index;
        final T defaultValue;
        Disposable s;
        long count;
        boolean done;

        public ElementAtSubscriber(Observer<? super T> actual, long index, T defaultValue) {
            this.actual = actual;
            this.index = index;
            this.defaultValue = defaultValue;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            long c = this.count;
            if (c == this.index) {
                this.done = true;
                this.s.dispose();
                this.actual.onNext(t);
                this.actual.onComplete();
                return;
            }
            this.count = c + 1L;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.index <= this.count && !this.done) {
                this.done = true;
                T v = this.defaultValue;
                if (v == null) {
                    this.actual.onError(new IndexOutOfBoundsException());
                } else {
                    this.actual.onNext(v);
                    this.actual.onComplete();
                }
            }
        }
    }
}

