/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import java.util.NoSuchElementException;

public final class SingleFromObservable<T>
extends Single<T> {
    private final Observable<T> upstream;

    public SingleFromObservable(Observable<T> upstream) {
        this.upstream = upstream;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        this.upstream.subscribe(new Observer<T>(){
            T last;

            @Override
            public void onSubscribe(Disposable d) {
                s.onSubscribe(d);
            }

            @Override
            public void onNext(T value) {
                this.last = value;
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
            }

            @Override
            public void onComplete() {
                Object v = this.last;
                this.last = null;
                if (v != null) {
                    s.onSuccess(v);
                } else {
                    s.onError(new NoSuchElementException());
                }
            }
        });
    }
}

