/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Notification;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableOperator;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.annotations.BackpressureKind;
import io.reactivex.annotations.BackpressureSupport;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.BooleanSupplier;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function3;
import io.reactivex.functions.Function4;
import io.reactivex.functions.Function5;
import io.reactivex.functions.Function6;
import io.reactivex.functions.Function7;
import io.reactivex.functions.Function8;
import io.reactivex.functions.Function9;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ScalarCallable;
import io.reactivex.internal.observers.BlockingFirstObserver;
import io.reactivex.internal.observers.BlockingLastObserver;
import io.reactivex.internal.observers.ForEachWhileObserver;
import io.reactivex.internal.observers.FutureObserver;
import io.reactivex.internal.observers.LambdaObserver;
import io.reactivex.internal.operators.flowable.FlowableFromObservable;
import io.reactivex.internal.operators.observable.BlockingObservableIterable;
import io.reactivex.internal.operators.observable.BlockingObservableLatest;
import io.reactivex.internal.operators.observable.BlockingObservableMostRecent;
import io.reactivex.internal.operators.observable.BlockingObservableNext;
import io.reactivex.internal.operators.observable.ObservableAllSingle;
import io.reactivex.internal.operators.observable.ObservableAmb;
import io.reactivex.internal.operators.observable.ObservableAnySingle;
import io.reactivex.internal.operators.observable.ObservableBlockingSubscribe;
import io.reactivex.internal.operators.observable.ObservableBuffer;
import io.reactivex.internal.operators.observable.ObservableBufferBoundary;
import io.reactivex.internal.operators.observable.ObservableBufferBoundarySupplier;
import io.reactivex.internal.operators.observable.ObservableBufferExactBoundary;
import io.reactivex.internal.operators.observable.ObservableBufferTimed;
import io.reactivex.internal.operators.observable.ObservableCache;
import io.reactivex.internal.operators.observable.ObservableCollectSingle;
import io.reactivex.internal.operators.observable.ObservableCombineLatest;
import io.reactivex.internal.operators.observable.ObservableConcatMap;
import io.reactivex.internal.operators.observable.ObservableConcatMapEager;
import io.reactivex.internal.operators.observable.ObservableCountSingle;
import io.reactivex.internal.operators.observable.ObservableCreate;
import io.reactivex.internal.operators.observable.ObservableDebounce;
import io.reactivex.internal.operators.observable.ObservableDebounceTimed;
import io.reactivex.internal.operators.observable.ObservableDefer;
import io.reactivex.internal.operators.observable.ObservableDelay;
import io.reactivex.internal.operators.observable.ObservableDelaySubscriptionOther;
import io.reactivex.internal.operators.observable.ObservableDematerialize;
import io.reactivex.internal.operators.observable.ObservableDetach;
import io.reactivex.internal.operators.observable.ObservableDistinct;
import io.reactivex.internal.operators.observable.ObservableDistinctUntilChanged;
import io.reactivex.internal.operators.observable.ObservableDoOnEach;
import io.reactivex.internal.operators.observable.ObservableDoOnLifecycle;
import io.reactivex.internal.operators.observable.ObservableElementAtMaybe;
import io.reactivex.internal.operators.observable.ObservableElementAtSingle;
import io.reactivex.internal.operators.observable.ObservableEmpty;
import io.reactivex.internal.operators.observable.ObservableError;
import io.reactivex.internal.operators.observable.ObservableFilter;
import io.reactivex.internal.operators.observable.ObservableFlatMap;
import io.reactivex.internal.operators.observable.ObservableFromArray;
import io.reactivex.internal.operators.observable.ObservableFromCallable;
import io.reactivex.internal.operators.observable.ObservableFromFuture;
import io.reactivex.internal.operators.observable.ObservableFromIterable;
import io.reactivex.internal.operators.observable.ObservableFromPublisher;
import io.reactivex.internal.operators.observable.ObservableFromUnsafeSource;
import io.reactivex.internal.operators.observable.ObservableGenerate;
import io.reactivex.internal.operators.observable.ObservableGroupBy;
import io.reactivex.internal.operators.observable.ObservableGroupJoin;
import io.reactivex.internal.operators.observable.ObservableHide;
import io.reactivex.internal.operators.observable.ObservableIgnoreElements;
import io.reactivex.internal.operators.observable.ObservableIgnoreElementsCompletable;
import io.reactivex.internal.operators.observable.ObservableInternalHelper;
import io.reactivex.internal.operators.observable.ObservableInterval;
import io.reactivex.internal.operators.observable.ObservableIntervalRange;
import io.reactivex.internal.operators.observable.ObservableJoin;
import io.reactivex.internal.operators.observable.ObservableJust;
import io.reactivex.internal.operators.observable.ObservableLastMaybe;
import io.reactivex.internal.operators.observable.ObservableLastSingle;
import io.reactivex.internal.operators.observable.ObservableLift;
import io.reactivex.internal.operators.observable.ObservableMap;
import io.reactivex.internal.operators.observable.ObservableMapNotification;
import io.reactivex.internal.operators.observable.ObservableMaterialize;
import io.reactivex.internal.operators.observable.ObservableNever;
import io.reactivex.internal.operators.observable.ObservableObserveOn;
import io.reactivex.internal.operators.observable.ObservableOnErrorNext;
import io.reactivex.internal.operators.observable.ObservableOnErrorReturn;
import io.reactivex.internal.operators.observable.ObservablePublish;
import io.reactivex.internal.operators.observable.ObservableRange;
import io.reactivex.internal.operators.observable.ObservableRedo;
import io.reactivex.internal.operators.observable.ObservableRepeat;
import io.reactivex.internal.operators.observable.ObservableRepeatUntil;
import io.reactivex.internal.operators.observable.ObservableReplay;
import io.reactivex.internal.operators.observable.ObservableRetryBiPredicate;
import io.reactivex.internal.operators.observable.ObservableRetryPredicate;
import io.reactivex.internal.operators.observable.ObservableSampleTimed;
import io.reactivex.internal.operators.observable.ObservableSampleWithObservable;
import io.reactivex.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.internal.operators.observable.ObservableScan;
import io.reactivex.internal.operators.observable.ObservableScanSeed;
import io.reactivex.internal.operators.observable.ObservableSequenceEqual;
import io.reactivex.internal.operators.observable.ObservableSerialized;
import io.reactivex.internal.operators.observable.ObservableSingleMaybe;
import io.reactivex.internal.operators.observable.ObservableSingleSingle;
import io.reactivex.internal.operators.observable.ObservableSkip;
import io.reactivex.internal.operators.observable.ObservableSkipLast;
import io.reactivex.internal.operators.observable.ObservableSkipLastTimed;
import io.reactivex.internal.operators.observable.ObservableSkipUntil;
import io.reactivex.internal.operators.observable.ObservableSkipWhile;
import io.reactivex.internal.operators.observable.ObservableSubscribeOn;
import io.reactivex.internal.operators.observable.ObservableSwitchIfEmpty;
import io.reactivex.internal.operators.observable.ObservableSwitchMap;
import io.reactivex.internal.operators.observable.ObservableTake;
import io.reactivex.internal.operators.observable.ObservableTakeLast;
import io.reactivex.internal.operators.observable.ObservableTakeLastOne;
import io.reactivex.internal.operators.observable.ObservableTakeLastTimed;
import io.reactivex.internal.operators.observable.ObservableTakeUntil;
import io.reactivex.internal.operators.observable.ObservableTakeUntilPredicate;
import io.reactivex.internal.operators.observable.ObservableTakeWhile;
import io.reactivex.internal.operators.observable.ObservableThrottleFirstTimed;
import io.reactivex.internal.operators.observable.ObservableTimeInterval;
import io.reactivex.internal.operators.observable.ObservableTimeout;
import io.reactivex.internal.operators.observable.ObservableTimeoutTimed;
import io.reactivex.internal.operators.observable.ObservableTimer;
import io.reactivex.internal.operators.observable.ObservableToList;
import io.reactivex.internal.operators.observable.ObservableToListSingle;
import io.reactivex.internal.operators.observable.ObservableUnsubscribeOn;
import io.reactivex.internal.operators.observable.ObservableUsing;
import io.reactivex.internal.operators.observable.ObservableWindow;
import io.reactivex.internal.operators.observable.ObservableWindowBoundary;
import io.reactivex.internal.operators.observable.ObservableWindowBoundarySelector;
import io.reactivex.internal.operators.observable.ObservableWindowBoundarySupplier;
import io.reactivex.internal.operators.observable.ObservableWindowTimed;
import io.reactivex.internal.operators.observable.ObservableWithLatestFrom;
import io.reactivex.internal.operators.observable.ObservableWithLatestFromMany;
import io.reactivex.internal.operators.observable.ObservableZip;
import io.reactivex.internal.operators.observable.ObservableZipIterable;
import io.reactivex.internal.util.ArrayListSupplier;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.HashMapSupplier;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.observables.GroupedObservable;
import io.reactivex.observers.SafeObserver;
import io.reactivex.observers.TestObserver;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.schedulers.Timed;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public abstract class Observable<T>
implements ObservableSource<T> {
    @SchedulerSupport(value="none")
    public static <T> Observable<T> amb(Iterable<? extends ObservableSource<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableAmb(null, sources));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> ambArray(ObservableSource<? extends T> ... sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        int len = sources.length;
        if (len == 0) {
            return Observable.empty();
        }
        if (len == 1) {
            return Observable.wrap(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new ObservableAmb<T>(sources, null));
    }

    public static int bufferSize() {
        return Flowable.bufferSize();
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> combineLatest(Function<? super Object[], ? extends R> combiner, int bufferSize, ObservableSource<? extends T> ... sources) {
        return Observable.combineLatest(sources, combiner, bufferSize);
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> combineLatest(Iterable<? extends ObservableSource<? extends T>> sources, Function<? super Object[], ? extends R> combiner) {
        return Observable.combineLatest(sources, combiner, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> combineLatest(Iterable<? extends ObservableSource<? extends T>> sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new ObservableCombineLatest(null, sources, combiner, s, false));
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> combineLatest(ObservableSource<? extends T>[] sources, Function<? super Object[], ? extends R> combiner) {
        return Observable.combineLatest(sources, combiner, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> combineLatest(ObservableSource<? extends T>[] sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Observable.empty();
        }
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new ObservableCombineLatest<T, R>(sources, null, combiner, s, false));
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, R> Observable<R> combineLatest(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> combiner) {
        return Observable.combineLatest(Functions.toFunction(combiner), Observable.bufferSize(), source1, source2);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, R> Observable<R> combineLatest(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, Function3<? super T1, ? super T2, ? super T3, ? extends R> combiner) {
        return Observable.combineLatest(Functions.toFunction(combiner), Observable.bufferSize(), source1, source2, source3);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, R> Observable<R> combineLatest(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combiner) {
        return Observable.combineLatest(Functions.toFunction(combiner), Observable.bufferSize(), source1, source2, source3, source4);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, R> Observable<R> combineLatest(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, ObservableSource<? extends T5> source5, Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combiner) {
        return Observable.combineLatest(Functions.toFunction(combiner), Observable.bufferSize(), source1, source2, source3, source4, source5);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, R> Observable<R> combineLatest(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, ObservableSource<? extends T5> source5, ObservableSource<? extends T6> source6, Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combiner) {
        return Observable.combineLatest(Functions.toFunction(combiner), Observable.bufferSize(), source1, source2, source3, source4, source5, source6);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable<R> combineLatest(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, ObservableSource<? extends T5> source5, ObservableSource<? extends T6> source6, ObservableSource<? extends T7> source7, Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combiner) {
        return Observable.combineLatest(Functions.toFunction(combiner), Observable.bufferSize(), source1, source2, source3, source4, source5, source6, source7);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable<R> combineLatest(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, ObservableSource<? extends T5> source5, ObservableSource<? extends T6> source6, ObservableSource<? extends T7> source7, ObservableSource<? extends T8> source8, Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combiner) {
        return Observable.combineLatest(Functions.toFunction(combiner), Observable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable<R> combineLatest(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, ObservableSource<? extends T5> source5, ObservableSource<? extends T6> source6, ObservableSource<? extends T7> source7, ObservableSource<? extends T8> source8, ObservableSource<? extends T9> source9, Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> combiner) {
        return Observable.combineLatest(Functions.toFunction(combiner), Observable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8, source9);
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> combineLatestDelayError(ObservableSource<? extends T>[] sources, Function<? super Object[], ? extends R> combiner) {
        return Observable.combineLatestDelayError(sources, combiner, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> combineLatestDelayError(Function<? super Object[], ? extends R> combiner, int bufferSize, ObservableSource<? extends T> ... sources) {
        return Observable.combineLatestDelayError(sources, combiner, bufferSize);
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> combineLatestDelayError(ObservableSource<? extends T>[] sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        if (sources.length == 0) {
            return Observable.empty();
        }
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new ObservableCombineLatest<T, R>(sources, null, combiner, s, true));
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> combineLatestDelayError(Iterable<? extends ObservableSource<? extends T>> sources, Function<? super Object[], ? extends R> combiner) {
        return Observable.combineLatestDelayError(sources, combiner, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> combineLatestDelayError(Iterable<? extends ObservableSource<? extends T>> sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new ObservableCombineLatest(null, sources, combiner, s, true));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concat(Iterable<? extends ObservableSource<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return Observable.fromIterable(sources).concatMapDelayError(Functions.identity(), Observable.bufferSize(), false);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concat(ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.concat(sources, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concat(ObservableSource<? extends ObservableSource<? extends T>> sources, int prefetch) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(sources, Functions.identity(), prefetch, ErrorMode.IMMEDIATE));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concat(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2) {
        return Observable.concatArray(source1, source2);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concat(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2, ObservableSource<? extends T> source3) {
        return Observable.concatArray(source1, source2, source3);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concat(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2, ObservableSource<? extends T> source3, ObservableSource<? extends T> source4) {
        return Observable.concatArray(source1, source2, source3, source4);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatArray(ObservableSource<? extends T> ... sources) {
        if (sources.length == 0) {
            return Observable.empty();
        }
        if (sources.length == 1) {
            return Observable.wrap(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(Observable.fromArray(sources), Functions.identity(), Observable.bufferSize(), ErrorMode.BOUNDARY));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatArrayDelayError(ObservableSource<? extends T> ... sources) {
        if (sources.length == 0) {
            return Observable.empty();
        }
        if (sources.length == 1) {
            return Observable.wrap(sources[0]);
        }
        return Observable.concatDelayError(Observable.fromArray(sources));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatArrayEager(ObservableSource<? extends T> ... sources) {
        return Observable.concatArrayEager(Observable.bufferSize(), Observable.bufferSize(), sources);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatArrayEager(int maxConcurrency, int prefetch, ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).concatMapEagerDelayError(Functions.identity(), maxConcurrency, prefetch, false);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatDelayError(Iterable<? extends ObservableSource<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return Observable.concatDelayError(Observable.fromIterable(sources));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatDelayError(ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.concatDelayError(sources, Observable.bufferSize(), true);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatDelayError(ObservableSource<? extends ObservableSource<? extends T>> sources, int prefetch, boolean tillTheEnd) {
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(sources, Functions.identity(), prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatEager(ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.concatEager(sources, Observable.bufferSize(), Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatEager(ObservableSource<? extends ObservableSource<? extends T>> sources, int maxConcurrency, int prefetch) {
        return Observable.wrap(sources).concatMapEager(Functions.identity(), maxConcurrency, prefetch);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatEager(Iterable<? extends ObservableSource<? extends T>> sources) {
        return Observable.concatEager(sources, Observable.bufferSize(), Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> concatEager(Iterable<? extends ObservableSource<? extends T>> sources, int maxConcurrency, int prefetch) {
        return Observable.fromIterable(sources).concatMapEagerDelayError(Functions.identity(), maxConcurrency, prefetch, false);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> create(ObservableOnSubscribe<T> source) {
        ObjectHelper.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new ObservableCreate<T>(source));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> defer(Callable<? extends ObservableSource<? extends T>> supplier) {
        ObjectHelper.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new ObservableDefer(supplier));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> empty() {
        return RxJavaPlugins.onAssembly(ObservableEmpty.INSTANCE);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> error(Callable<? extends Throwable> errorSupplier) {
        ObjectHelper.requireNonNull(errorSupplier, "errorSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableError(errorSupplier));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> error(Throwable exception) {
        ObjectHelper.requireNonNull(exception, "e is null");
        return Observable.error(Functions.justCallable(exception));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> fromArray(T ... items) {
        ObjectHelper.requireNonNull(items, "items is null");
        if (items.length == 0) {
            return Observable.empty();
        }
        if (items.length == 1) {
            return Observable.just(items[0]);
        }
        return RxJavaPlugins.onAssembly(new ObservableFromArray<T>(items));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> fromCallable(Callable<? extends T> supplier) {
        ObjectHelper.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new ObservableFromCallable<T>(supplier));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> fromFuture(Future<? extends T> future) {
        ObjectHelper.requireNonNull(future, "future is null");
        return RxJavaPlugins.onAssembly(new ObservableFromFuture<T>(future, 0L, null));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> fromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        ObjectHelper.requireNonNull(future, "future is null");
        ObjectHelper.requireNonNull(unit, "unit is null");
        return RxJavaPlugins.onAssembly(new ObservableFromFuture<T>(future, timeout, unit));
    }

    @SchedulerSupport(value="custom")
    public static <T> Observable<T> fromFuture(Future<? extends T> future, long timeout, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        Observable<T> o = Observable.fromFuture(future, timeout, unit);
        return o.subscribeOn(scheduler);
    }

    @SchedulerSupport(value="custom")
    public static <T> Observable<T> fromFuture(Future<? extends T> future, Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        Observable<T> o = Observable.fromFuture(future);
        return o.subscribeOn(scheduler);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> fromIterable(Iterable<? extends T> source) {
        ObjectHelper.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new ObservableFromIterable<T>(source));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public static <T> Observable<T> fromPublisher(Publisher<? extends T> publisher) {
        ObjectHelper.requireNonNull(publisher, "publisher is null");
        return RxJavaPlugins.onAssembly(new ObservableFromPublisher<T>(publisher));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> generate(Consumer<Emitter<T>> generator) {
        ObjectHelper.requireNonNull(generator, "generator  is null");
        return Observable.generate(Functions.nullSupplier(), ObservableInternalHelper.simpleGenerator(generator), Functions.emptyConsumer());
    }

    @SchedulerSupport(value="none")
    public static <T, S> Observable<T> generate(Callable<S> initialState, BiConsumer<S, Emitter<T>> generator) {
        ObjectHelper.requireNonNull(generator, "generator  is null");
        return Observable.generate(initialState, ObservableInternalHelper.simpleBiGenerator(generator), Functions.emptyConsumer());
    }

    @SchedulerSupport(value="none")
    public static <T, S> Observable<T> generate(Callable<S> initialState, BiConsumer<S, Emitter<T>> generator, Consumer<? super S> disposeState) {
        ObjectHelper.requireNonNull(generator, "generator  is null");
        return Observable.generate(initialState, ObservableInternalHelper.simpleBiGenerator(generator), disposeState);
    }

    @SchedulerSupport(value="none")
    public static <T, S> Observable<T> generate(Callable<S> initialState, BiFunction<S, Emitter<T>, S> generator) {
        return Observable.generate(initialState, generator, Functions.emptyConsumer());
    }

    @SchedulerSupport(value="none")
    public static <T, S> Observable<T> generate(Callable<S> initialState, BiFunction<S, Emitter<T>, S> generator, Consumer<? super S> disposeState) {
        ObjectHelper.requireNonNull(initialState, "initialState is null");
        ObjectHelper.requireNonNull(generator, "generator  is null");
        ObjectHelper.requireNonNull(disposeState, "disposeState is null");
        return RxJavaPlugins.onAssembly(new ObservableGenerate<T, S>(initialState, generator, disposeState));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public static Observable<Long> interval(long initialDelay, long period, TimeUnit unit) {
        return Observable.interval(initialDelay, period, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public static Observable<Long> interval(long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableInterval(Math.max(0L, initialDelay), Math.max(0L, period), unit, scheduler));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public static Observable<Long> interval(long period, TimeUnit unit) {
        return Observable.interval(period, period, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public static Observable<Long> interval(long period, TimeUnit unit, Scheduler scheduler) {
        return Observable.interval(period, period, unit, scheduler);
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public static Observable<Long> intervalRange(long start, long count, long initialDelay, long period, TimeUnit unit) {
        return Observable.intervalRange(start, count, initialDelay, period, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public static Observable<Long> intervalRange(long start, long count, long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0L) {
            return Observable.empty().delay(initialDelay, unit, scheduler);
        }
        long end = start + (count - 1L);
        if (start > 0L && end < 0L) {
            throw new IllegalArgumentException("Overflow! start + count is bigger than Long.MAX_VALUE");
        }
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableIntervalRange(start, end, Math.max(0L, initialDelay), Math.max(0L, period), unit, scheduler));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> just(T item) {
        ObjectHelper.requireNonNull(item, "The item is null");
        return RxJavaPlugins.onAssembly(new ObservableJust<T>(item));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> just(T item1, T item2) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        return Observable.fromArray(item1, item2);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> just(T item1, T item2, T item3) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        return Observable.fromArray(item1, item2, item3);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> just(T item1, T item2, T item3, T item4) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        return Observable.fromArray(item1, item2, item3, item4);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> just(T item1, T item2, T item3, T item4, T item5) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        return Observable.fromArray(item1, item2, item3, item4, item5);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> just(T item1, T item2, T item3, T item4, T item5, T item6) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        ObjectHelper.requireNonNull(item6, "The sixth item is null");
        return Observable.fromArray(item1, item2, item3, item4, item5, item6);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        ObjectHelper.requireNonNull(item6, "The sixth item is null");
        ObjectHelper.requireNonNull(item7, "The seventh item is null");
        return Observable.fromArray(item1, item2, item3, item4, item5, item6, item7);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        ObjectHelper.requireNonNull(item6, "The sixth item is null");
        ObjectHelper.requireNonNull(item7, "The seventh item is null");
        ObjectHelper.requireNonNull(item8, "The eighth item is null");
        return Observable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8, T item9) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        ObjectHelper.requireNonNull(item6, "The sixth item is null");
        ObjectHelper.requireNonNull(item7, "The seventh item is null");
        ObjectHelper.requireNonNull(item8, "The eighth item is null");
        ObjectHelper.requireNonNull(item9, "The ninth item is null");
        return Observable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8, item9);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8, T item9, T item10) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        ObjectHelper.requireNonNull(item6, "The sixth item is null");
        ObjectHelper.requireNonNull(item7, "The seventh item is null");
        ObjectHelper.requireNonNull(item8, "The eighth item is null");
        ObjectHelper.requireNonNull(item9, "The ninth item is null");
        ObjectHelper.requireNonNull(item10, "The tenth item is null");
        return Observable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8, item9, item10);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> merge(Iterable<? extends ObservableSource<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Observable.fromIterable(sources).flatMap(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeArray(int maxConcurrency, int bufferSize, ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).flatMap(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> merge(Iterable<? extends ObservableSource<? extends T>> sources) {
        return Observable.fromIterable(sources).flatMap(Functions.identity());
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> merge(Iterable<? extends ObservableSource<? extends T>> sources, int maxConcurrency) {
        return Observable.fromIterable(sources).flatMap(Functions.identity(), maxConcurrency);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> merge(ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return RxJavaPlugins.onAssembly(new ObservableFlatMap(sources, Functions.identity(), false, Integer.MAX_VALUE, Observable.bufferSize()));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> merge(ObservableSource<? extends ObservableSource<? extends T>> sources, int maxConcurrency) {
        return RxJavaPlugins.onAssembly(new ObservableFlatMap(sources, Functions.identity(), false, maxConcurrency, Observable.bufferSize()));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> merge(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Observable.fromArray(source1, source2).flatMap(Functions.identity(), false, 2);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> merge(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2, ObservableSource<? extends T> source3) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        return Observable.fromArray(source1, source2, source3).flatMap(Functions.identity(), false, 3);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> merge(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2, ObservableSource<? extends T> source3, ObservableSource<? extends T> source4) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        return Observable.fromArray(source1, source2, source3, source4).flatMap(Functions.identity(), false, 4);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeArray(ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).flatMap(Functions.identity(), sources.length);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeDelayError(Iterable<? extends ObservableSource<? extends T>> sources) {
        return Observable.fromIterable(sources).flatMap(Functions.identity(), true);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeDelayError(Iterable<? extends ObservableSource<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Observable.fromIterable(sources).flatMap(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeArrayDelayError(int maxConcurrency, int bufferSize, ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).flatMap(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeDelayError(Iterable<? extends ObservableSource<? extends T>> sources, int maxConcurrency) {
        return Observable.fromIterable(sources).flatMap(Functions.identity(), true, maxConcurrency);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeDelayError(ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return RxJavaPlugins.onAssembly(new ObservableFlatMap(sources, Functions.identity(), true, Integer.MAX_VALUE, Observable.bufferSize()));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeDelayError(ObservableSource<? extends ObservableSource<? extends T>> sources, int maxConcurrency) {
        return RxJavaPlugins.onAssembly(new ObservableFlatMap(sources, Functions.identity(), true, maxConcurrency, Observable.bufferSize()));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeDelayError(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Observable.fromArray(source1, source2).flatMap(Functions.identity(), true, 2);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeDelayError(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2, ObservableSource<? extends T> source3) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        return Observable.fromArray(source1, source2, source3).flatMap(Functions.identity(), true, 3);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeDelayError(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2, ObservableSource<? extends T> source3, ObservableSource<? extends T> source4) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        return Observable.fromArray(source1, source2, source3, source4).flatMap(Functions.identity(), true, 4);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> mergeArrayDelayError(ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).flatMap(Functions.identity(), true, sources.length);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> never() {
        return RxJavaPlugins.onAssembly(ObservableNever.INSTANCE);
    }

    @SchedulerSupport(value="none")
    public static Observable<Integer> range(int start, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return Observable.empty();
        }
        if (count == 1) {
            return Observable.just(start);
        }
        if ((long)start + (long)(count - 1) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer overflow");
        }
        return RxJavaPlugins.onAssembly(new ObservableRange(start, count));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<Boolean> sequenceEqual(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2) {
        return Observable.sequenceEqual(source1, source2, ObjectHelper.equalsPredicate(), Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<Boolean> sequenceEqual(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2, BiPredicate<? super T, ? super T> isEqual) {
        return Observable.sequenceEqual(source1, source2, isEqual, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<Boolean> sequenceEqual(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2, BiPredicate<? super T, ? super T> isEqual, int bufferSize) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(isEqual, "isEqual is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableSequenceEqual<T>(source1, source2, isEqual, bufferSize));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<Boolean> sequenceEqual(ObservableSource<? extends T> source1, ObservableSource<? extends T> source2, int bufferSize) {
        return Observable.sequenceEqual(source1, source2, ObjectHelper.equalsPredicate(), bufferSize);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> switchOnNext(ObservableSource<? extends ObservableSource<? extends T>> sources, int bufferSize) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableSwitchMap(sources, Functions.identity(), bufferSize, false));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> switchOnNext(ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.switchOnNext(sources, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> switchOnNextDelayError(ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.switchOnNextDelayError(sources, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> switchOnNextDelayError(ObservableSource<? extends ObservableSource<? extends T>> sources, int prefetch) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new ObservableSwitchMap(sources, Functions.identity(), prefetch, true));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public static Observable<Long> timer(long delay, TimeUnit unit) {
        return Observable.timer(delay, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public static Observable<Long> timer(long delay, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableTimer(Math.max(delay, 0L), unit, scheduler));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> unsafeCreate(ObservableSource<T> onSubscribe) {
        ObjectHelper.requireNonNull(onSubscribe, "source is null");
        ObjectHelper.requireNonNull(onSubscribe, "onSubscribe is null");
        if (onSubscribe instanceof Observable) {
            throw new IllegalArgumentException("unsafeCreate(Observable) should be upgraded");
        }
        return RxJavaPlugins.onAssembly(new ObservableFromUnsafeSource<T>(onSubscribe));
    }

    @SchedulerSupport(value="none")
    public static <T, D> Observable<T> using(Callable<? extends D> resourceSupplier, Function<? super D, ? extends ObservableSource<? extends T>> sourceSupplier, Consumer<? super D> disposer) {
        return Observable.using(resourceSupplier, sourceSupplier, disposer, true);
    }

    @SchedulerSupport(value="none")
    public static <T, D> Observable<T> using(Callable<? extends D> resourceSupplier, Function<? super D, ? extends ObservableSource<? extends T>> sourceSupplier, Consumer<? super D> disposer, boolean eager) {
        ObjectHelper.requireNonNull(resourceSupplier, "resourceSupplier is null");
        ObjectHelper.requireNonNull(sourceSupplier, "sourceSupplier is null");
        ObjectHelper.requireNonNull(disposer, "disposer is null");
        return RxJavaPlugins.onAssembly(new ObservableUsing(resourceSupplier, sourceSupplier, disposer, eager));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> wrap(ObservableSource<T> source) {
        ObjectHelper.requireNonNull(source, "source is null");
        if (source instanceof Observable) {
            return RxJavaPlugins.onAssembly((Observable)source);
        }
        return RxJavaPlugins.onAssembly(new ObservableFromUnsafeSource<T>(source));
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> zip(Iterable<? extends ObservableSource<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableZip(null, sources, zipper, Observable.bufferSize(), false));
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> zip(ObservableSource<? extends ObservableSource<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableToList(sources, 16).flatMap(ObservableInternalHelper.zipIterable(zipper)));
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, R> Observable<R> zip(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, R> Observable<R> zip(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> zipper, boolean delayError) {
        return Observable.zipArray(Functions.toFunction(zipper), delayError, Observable.bufferSize(), source1, source2);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, R> Observable<R> zip(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> zipper, boolean delayError, int bufferSize) {
        return Observable.zipArray(Functions.toFunction(zipper), delayError, bufferSize, source1, source2);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, R> Observable<R> zip(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, R> Observable<R> zip(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, R> Observable<R> zip(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, ObservableSource<? extends T5> source5, Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipper) {
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4, source5);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, R> Observable<R> zip(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, ObservableSource<? extends T5> source5, ObservableSource<? extends T6> source6, Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipper) {
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4, source5, source6);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable<R> zip(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, ObservableSource<? extends T5> source5, ObservableSource<? extends T6> source6, ObservableSource<? extends T7> source7, Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipper) {
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4, source5, source6, source7);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable<R> zip(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, ObservableSource<? extends T5> source5, ObservableSource<? extends T6> source6, ObservableSource<? extends T7> source7, ObservableSource<? extends T8> source8, Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipper) {
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8);
    }

    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable<R> zip(ObservableSource<? extends T1> source1, ObservableSource<? extends T2> source2, ObservableSource<? extends T3> source3, ObservableSource<? extends T4> source4, ObservableSource<? extends T5> source5, ObservableSource<? extends T6> source6, ObservableSource<? extends T7> source7, ObservableSource<? extends T8> source8, ObservableSource<? extends T9> source9, Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipper) {
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8, source9);
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> zipArray(Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize, ObservableSource<? extends T> ... sources) {
        if (sources.length == 0) {
            return Observable.empty();
        }
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableZip<T, R>(sources, null, zipper, bufferSize, delayError));
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable<R> zipIterable(Iterable<? extends ObservableSource<? extends T>> sources, Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        ObjectHelper.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableZip(null, sources, zipper, bufferSize, delayError));
    }

    @SchedulerSupport(value="none")
    public final Single<Boolean> all(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableAllSingle<T>(this, predicate));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> ambWith(ObservableSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Observable.ambArray(this, other);
    }

    @SchedulerSupport(value="none")
    public final Single<Boolean> any(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableAnySingle<T>(this, predicate));
    }

    @SchedulerSupport(value="none")
    public final T blockingFirst() {
        BlockingFirstObserver s = new BlockingFirstObserver();
        this.subscribe(s);
        Object v = s.blockingGet();
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException();
    }

    @SchedulerSupport(value="none")
    public final T blockingFirst(T defaultItem) {
        BlockingFirstObserver s = new BlockingFirstObserver();
        this.subscribe(s);
        Object v = s.blockingGet();
        return v != null ? v : defaultItem;
    }

    @SchedulerSupport(value="none")
    public final void blockingForEach(Consumer<? super T> onNext) {
        Iterator<T> it = this.blockingIterable().iterator();
        while (it.hasNext()) {
            try {
                onNext.accept(it.next());
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                ((Disposable)((Object)it)).dispose();
                throw ExceptionHelper.wrapOrThrow(e);
            }
        }
    }

    @SchedulerSupport(value="none")
    public final Iterable<T> blockingIterable() {
        return this.blockingIterable(Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final Iterable<T> blockingIterable(int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return new BlockingObservableIterable(this, bufferSize);
    }

    @SchedulerSupport(value="none")
    public final T blockingLast() {
        BlockingLastObserver s = new BlockingLastObserver();
        this.subscribe(s);
        Object v = s.blockingGet();
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException();
    }

    @SchedulerSupport(value="none")
    public final T blockingLast(T defaultItem) {
        BlockingLastObserver s = new BlockingLastObserver();
        this.subscribe(s);
        Object v = s.blockingGet();
        return v != null ? v : defaultItem;
    }

    @SchedulerSupport(value="none")
    public final Iterable<T> blockingLatest() {
        return BlockingObservableLatest.latest(this);
    }

    @SchedulerSupport(value="none")
    public final Iterable<T> blockingMostRecent(T initialValue) {
        return BlockingObservableMostRecent.mostRecent(this, initialValue);
    }

    @SchedulerSupport(value="none")
    public final Iterable<T> blockingNext() {
        return BlockingObservableNext.next(this);
    }

    @SchedulerSupport(value="none")
    public final T blockingSingle() {
        T v = this.singleElement().blockingGet();
        if (v == null) {
            throw new NoSuchElementException();
        }
        return v;
    }

    @SchedulerSupport(value="none")
    public final T blockingSingle(T defaultItem) {
        return this.single(defaultItem).blockingGet();
    }

    @SchedulerSupport(value="none")
    public final Future<T> toFuture() {
        return this.subscribeWith(new FutureObserver());
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe() {
        ObservableBlockingSubscribe.subscribe(this);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Consumer<? super T> onNext) {
        ObservableBlockingSubscribe.subscribe(this, onNext, Functions.ERROR_CONSUMER, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError) {
        ObservableBlockingSubscribe.subscribe(this, onNext, onError, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        ObservableBlockingSubscribe.subscribe(this, onNext, onError, onComplete);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Observer<? super T> subscriber) {
        ObservableBlockingSubscribe.subscribe(this, subscriber);
    }

    @SchedulerSupport(value="none")
    public final Observable<List<T>> buffer(int count) {
        return this.buffer(count, count);
    }

    @SchedulerSupport(value="none")
    public final Observable<List<T>> buffer(int count, int skip) {
        return this.buffer(count, skip, ArrayListSupplier.asCallable());
    }

    @SchedulerSupport(value="none")
    public final <U extends Collection<? super T>> Observable<U> buffer(int count, int skip, Callable<U> bufferSupplier) {
        ObjectHelper.verifyPositive(count, "count");
        ObjectHelper.verifyPositive(skip, "skip");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableBuffer(this, count, skip, bufferSupplier));
    }

    @SchedulerSupport(value="none")
    public final <U extends Collection<? super T>> Observable<U> buffer(int count, Callable<U> bufferSupplier) {
        return this.buffer(count, count, bufferSupplier);
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<List<T>> buffer(long timespan, long timeskip, TimeUnit unit) {
        return this.buffer(timespan, timeskip, unit, Schedulers.computation(), ArrayListSupplier.asCallable());
    }

    @SchedulerSupport(value="custom")
    public final Observable<List<T>> buffer(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler) {
        return this.buffer(timespan, timeskip, unit, scheduler, ArrayListSupplier.asCallable());
    }

    @SchedulerSupport(value="custom")
    public final <U extends Collection<? super T>> Observable<U> buffer(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableBufferTimed(this, timespan, timeskip, unit, scheduler, bufferSupplier, Integer.MAX_VALUE, false));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<List<T>> buffer(long timespan, TimeUnit unit) {
        return this.buffer(timespan, unit, Integer.MAX_VALUE, Schedulers.computation());
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<List<T>> buffer(long timespan, TimeUnit unit, int count) {
        return this.buffer(timespan, unit, count, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public final Observable<List<T>> buffer(long timespan, TimeUnit unit, int count, Scheduler scheduler) {
        return this.buffer(timespan, unit, count, scheduler, ArrayListSupplier.asCallable(), false);
    }

    @SchedulerSupport(value="custom")
    public final <U extends Collection<? super T>> Observable<U> buffer(long timespan, TimeUnit unit, int count, Scheduler scheduler, Callable<U> bufferSupplier, boolean restartTimerOnMaxSize) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        ObjectHelper.verifyPositive(count, "count");
        return RxJavaPlugins.onAssembly(new ObservableBufferTimed(this, timespan, timespan, unit, scheduler, bufferSupplier, count, restartTimerOnMaxSize));
    }

    @SchedulerSupport(value="custom")
    public final Observable<List<T>> buffer(long timespan, TimeUnit unit, Scheduler scheduler) {
        return this.buffer(timespan, unit, Integer.MAX_VALUE, scheduler, ArrayListSupplier.asCallable(), false);
    }

    @SchedulerSupport(value="none")
    public final <TOpening, TClosing> Observable<List<T>> buffer(ObservableSource<? extends TOpening> openingIndicator, Function<? super TOpening, ? extends ObservableSource<? extends TClosing>> closingIndicator) {
        return this.buffer(openingIndicator, closingIndicator, ArrayListSupplier.asCallable());
    }

    @SchedulerSupport(value="none")
    public final <TOpening, TClosing, U extends Collection<? super T>> Observable<U> buffer(ObservableSource<? extends TOpening> openingIndicator, Function<? super TOpening, ? extends ObservableSource<? extends TClosing>> closingIndicator, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(openingIndicator, "openingIndicator is null");
        ObjectHelper.requireNonNull(closingIndicator, "closingIndicator is null");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableBufferBoundary(this, openingIndicator, closingIndicator, bufferSupplier));
    }

    @SchedulerSupport(value="none")
    public final <B> Observable<List<T>> buffer(ObservableSource<B> boundary) {
        return this.buffer(boundary, ArrayListSupplier.asCallable());
    }

    @SchedulerSupport(value="none")
    public final <B> Observable<List<T>> buffer(ObservableSource<B> boundary, int initialCapacity) {
        return this.buffer(boundary, Functions.createArrayList(initialCapacity));
    }

    @SchedulerSupport(value="none")
    public final <B, U extends Collection<? super T>> Observable<U> buffer(ObservableSource<B> boundary, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(boundary, "boundary is null");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableBufferExactBoundary(this, boundary, bufferSupplier));
    }

    @SchedulerSupport(value="none")
    public final <B> Observable<List<T>> buffer(Callable<? extends ObservableSource<B>> boundarySupplier) {
        return this.buffer(boundarySupplier, ArrayListSupplier.asCallable());
    }

    @SchedulerSupport(value="none")
    public final <B, U extends Collection<? super T>> Observable<U> buffer(Callable<? extends ObservableSource<B>> boundarySupplier, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(boundarySupplier, "boundarySupplier is null");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableBufferBoundarySupplier(this, boundarySupplier, bufferSupplier));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> cache() {
        return ObservableCache.from(this);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> cacheWithInitialCapacity(int initialCapacity) {
        return ObservableCache.from(this, initialCapacity);
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<U> cast(Class<U> clazz) {
        ObjectHelper.requireNonNull(clazz, "clazz is null");
        return this.map(Functions.castFunction(clazz));
    }

    @SchedulerSupport(value="none")
    public final <U> Single<U> collect(Callable<? extends U> initialValueSupplier, BiConsumer<? super U, ? super T> collector) {
        ObjectHelper.requireNonNull(initialValueSupplier, "initialValueSupplier is null");
        ObjectHelper.requireNonNull(collector, "collector is null");
        return RxJavaPlugins.onAssembly(new ObservableCollectSingle<T, U>(this, initialValueSupplier, collector));
    }

    @SchedulerSupport(value="none")
    public final <U> Single<U> collectInto(U initialValue, BiConsumer<? super U, ? super T> collector) {
        ObjectHelper.requireNonNull(initialValue, "initialValue is null");
        return this.collect(Functions.justCallable(initialValue), collector);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> compose(Function<? super Observable<T>, ? extends ObservableSource<R>> composer) {
        return Observable.wrap(this.to(composer));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> concatMap(Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.concatMap(mapper, 2);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> concatMap(Function<? super T, ? extends ObservableSource<? extends R>> mapper, int prefetch) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        if (this instanceof ScalarCallable) {
            Object v = ((ScalarCallable)((Object)this)).call();
            if (v == null) {
                return Observable.empty();
            }
            return ObservableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(this, mapper, prefetch, ErrorMode.IMMEDIATE));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> concatMapDelayError(Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.concatMapDelayError(mapper, Observable.bufferSize(), true);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> concatMapDelayError(Function<? super T, ? extends ObservableSource<? extends R>> mapper, int prefetch, boolean tillTheEnd) {
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        if (this instanceof ScalarCallable) {
            Object v = ((ScalarCallable)((Object)this)).call();
            if (v == null) {
                return Observable.empty();
            }
            return ObservableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(this, mapper, prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> concatMapEager(Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.concatMapEager(mapper, Integer.MAX_VALUE, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> concatMapEager(Function<? super T, ? extends ObservableSource<? extends R>> mapper, int maxConcurrency, int prefetch) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapEager(this, mapper, ErrorMode.IMMEDIATE, maxConcurrency, prefetch));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> concatMapEagerDelayError(Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapEagerDelayError(mapper, Integer.MAX_VALUE, Observable.bufferSize(), tillTheEnd);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> concatMapEagerDelayError(Function<? super T, ? extends ObservableSource<? extends R>> mapper, int maxConcurrency, int prefetch, boolean tillTheEnd) {
        return RxJavaPlugins.onAssembly(new ObservableConcatMapEager(this, mapper, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY, maxConcurrency, prefetch));
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<U> concatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return this.concatMap(ObservableInternalHelper.flatMapIntoIterable(mapper));
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<U> concatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, int prefetch) {
        return this.concatMap(ObservableInternalHelper.flatMapIntoIterable(mapper), prefetch);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> concatWith(ObservableSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Observable.concat(this, other);
    }

    @SchedulerSupport(value="none")
    public final Single<Boolean> contains(Object element) {
        ObjectHelper.requireNonNull(element, "element is null");
        return this.any(Functions.equalsWith(element));
    }

    @SchedulerSupport(value="none")
    public final Single<Long> count() {
        return RxJavaPlugins.onAssembly(new ObservableCountSingle(this));
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<T> debounce(Function<? super T, ? extends ObservableSource<U>> debounceSelector) {
        ObjectHelper.requireNonNull(debounceSelector, "debounceSelector is null");
        return RxJavaPlugins.onAssembly(new ObservableDebounce(this, debounceSelector));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> debounce(long timeout, TimeUnit unit) {
        return this.debounce(timeout, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> debounce(long timeout, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableDebounceTimed(this, timeout, unit, scheduler));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> defaultIfEmpty(T defaultItem) {
        ObjectHelper.requireNonNull(defaultItem, "defaultItem is null");
        return this.switchIfEmpty(Observable.just(defaultItem));
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<T> delay(Function<? super T, ? extends ObservableSource<U>> itemDelay) {
        ObjectHelper.requireNonNull(itemDelay, "itemDelay is null");
        return this.flatMap(ObservableInternalHelper.itemDelay(itemDelay));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> delay(long delay, TimeUnit unit) {
        return this.delay(delay, unit, Schedulers.computation(), false);
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> delay(long delay, TimeUnit unit, boolean delayError) {
        return this.delay(delay, unit, Schedulers.computation(), delayError);
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> delay(long delay, TimeUnit unit, Scheduler scheduler) {
        return this.delay(delay, unit, scheduler, false);
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> delay(long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableDelay(this, delay, unit, scheduler, delayError));
    }

    @SchedulerSupport(value="none")
    public final <U, V> Observable<T> delay(ObservableSource<U> subscriptionDelay, Function<? super T, ? extends ObservableSource<V>> itemDelay) {
        return this.delaySubscription(subscriptionDelay).delay(itemDelay);
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<T> delaySubscription(ObservableSource<U> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableDelaySubscriptionOther(this, other));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> delaySubscription(long delay, TimeUnit unit) {
        return this.delaySubscription(delay, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> delaySubscription(long delay, TimeUnit unit, Scheduler scheduler) {
        return this.delaySubscription(Observable.timer(delay, unit, scheduler));
    }

    @SchedulerSupport(value="none")
    public final <T2> Observable<T2> dematerialize() {
        Observable m = this;
        return RxJavaPlugins.onAssembly(new ObservableDematerialize(m));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> distinct() {
        return this.distinct(Functions.identity(), Functions.createHashSet());
    }

    @SchedulerSupport(value="none")
    public final <K> Observable<T> distinct(Function<? super T, K> keySelector) {
        return this.distinct(keySelector, Functions.createHashSet());
    }

    @SchedulerSupport(value="none")
    public final <K> Observable<T> distinct(Function<? super T, K> keySelector, Callable<? extends Collection<? super K>> collectionSupplier) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        ObjectHelper.requireNonNull(collectionSupplier, "collectionSupplier is null");
        return ObservableDistinct.withCollection(this, keySelector, collectionSupplier);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> distinctUntilChanged() {
        return ObservableDistinct.untilChanged(this);
    }

    @SchedulerSupport(value="none")
    public final <K> Observable<T> distinctUntilChanged(Function<? super T, K> keySelector) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        return ObservableDistinct.untilChanged(this, keySelector);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> distinctUntilChanged(BiPredicate<? super T, ? super T> comparer) {
        ObjectHelper.requireNonNull(comparer, "comparer is null");
        return RxJavaPlugins.onAssembly(new ObservableDistinctUntilChanged<T>(this, comparer));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> doAfterTerminate(Action onFinally) {
        ObjectHelper.requireNonNull(onFinally, "onFinally is null");
        return this.doOnEach(Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, onFinally);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> doOnDispose(Action onDispose) {
        return this.doOnLifecycle(Functions.emptyConsumer(), onDispose);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> doOnComplete(Action onComplete) {
        return this.doOnEach(Functions.emptyConsumer(), Functions.emptyConsumer(), onComplete, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    private Observable<T> doOnEach(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
        ObjectHelper.requireNonNull(onNext, "onNext is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        ObjectHelper.requireNonNull(onAfterTerminate, "onAfterTerminate is null");
        return RxJavaPlugins.onAssembly(new ObservableDoOnEach<T>(this, onNext, onError, onComplete, onAfterTerminate));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> doOnEach(Consumer<? super Notification<T>> onNotification) {
        ObjectHelper.requireNonNull(onNotification, "consumer is null");
        return this.doOnEach(Functions.notificationOnNext(onNotification), Functions.notificationOnError(onNotification), Functions.notificationOnComplete(onNotification), Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> doOnEach(Observer<? super T> observer) {
        ObjectHelper.requireNonNull(observer, "observer is null");
        return this.doOnEach(ObservableInternalHelper.observerOnNext(observer), ObservableInternalHelper.observerOnError(observer), ObservableInternalHelper.observerOnComplete(observer), Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> doOnError(Consumer<? super Throwable> onError) {
        return this.doOnEach(Functions.emptyConsumer(), onError, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> doOnLifecycle(Consumer<? super Disposable> onSubscribe, Action onDispose) {
        ObjectHelper.requireNonNull(onSubscribe, "onSubscribe is null");
        ObjectHelper.requireNonNull(onDispose, "onDispose is null");
        return RxJavaPlugins.onAssembly(new ObservableDoOnLifecycle(this, onSubscribe, onDispose));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> doOnNext(Consumer<? super T> onNext) {
        return this.doOnEach(onNext, Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> doOnSubscribe(Consumer<? super Disposable> onSubscribe) {
        return this.doOnLifecycle(onSubscribe, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> doOnTerminate(Action onTerminate) {
        ObjectHelper.requireNonNull(onTerminate, "onTerminate is null");
        return this.doOnEach(Functions.emptyConsumer(), Functions.actionConsumer(onTerminate), onTerminate, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final Maybe<T> elementAt(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        return RxJavaPlugins.onAssembly(new ObservableElementAtMaybe(this, index));
    }

    @SchedulerSupport(value="none")
    public final Single<T> elementAt(long index, T defaultItem) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        ObjectHelper.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new ObservableElementAtSingle<T>(this, index, defaultItem));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> filter(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableFilter<T>(this, predicate));
    }

    @SchedulerSupport(value="none")
    public final Maybe<T> firstElement() {
        return this.elementAt(0L);
    }

    @SchedulerSupport(value="none")
    public final Single<T> first(T defaultItem) {
        return this.elementAt(0L, defaultItem);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.flatMap(mapper, false);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean delayErrors) {
        return this.flatMap(mapper, delayErrors, Integer.MAX_VALUE);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
        return this.flatMap(mapper, delayErrors, maxConcurrency, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (this instanceof ScalarCallable) {
            Object v = ((ScalarCallable)((Object)this)).call();
            if (v == null) {
                return Observable.empty();
            }
            return ObservableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new ObservableFlatMap(this, mapper, delayErrors, maxConcurrency, bufferSize));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends R>> onNextMapper, Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorMapper, Callable<? extends ObservableSource<? extends R>> onCompleteSupplier) {
        ObjectHelper.requireNonNull(onNextMapper, "onNextMapper is null");
        ObjectHelper.requireNonNull(onErrorMapper, "onErrorMapper is null");
        ObjectHelper.requireNonNull(onCompleteSupplier, "onCompleteSupplier is null");
        return Observable.merge(new ObservableMapNotification(this, onNextMapper, onErrorMapper, onCompleteSupplier));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends R>> onNextMapper, Function<Throwable, ? extends ObservableSource<? extends R>> onErrorMapper, Callable<? extends ObservableSource<? extends R>> onCompleteSupplier, int maxConcurrency) {
        ObjectHelper.requireNonNull(onNextMapper, "onNextMapper is null");
        ObjectHelper.requireNonNull(onErrorMapper, "onErrorMapper is null");
        ObjectHelper.requireNonNull(onCompleteSupplier, "onCompleteSupplier is null");
        return Observable.merge(new ObservableMapNotification(this, onNextMapper, onErrorMapper, onCompleteSupplier), maxConcurrency);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends R>> mapper, int maxConcurrency) {
        return this.flatMap(mapper, false, maxConcurrency, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <U, R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> resultSelector) {
        return this.flatMap(mapper, resultSelector, false, Observable.bufferSize(), Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <U, R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors) {
        return this.flatMap(mapper, combiner, delayErrors, Observable.bufferSize(), Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <U, R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors, int maxConcurrency) {
        return this.flatMap(mapper, combiner, delayErrors, maxConcurrency, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <U, R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors, int maxConcurrency, int bufferSize) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        return this.flatMap(ObservableInternalHelper.flatMapWithCombiner(mapper, combiner), delayErrors, maxConcurrency, bufferSize);
    }

    @SchedulerSupport(value="none")
    public final <U, R> Observable<R> flatMap(Function<? super T, ? extends ObservableSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, int maxConcurrency) {
        return this.flatMap(mapper, combiner, false, maxConcurrency, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<U> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return this.flatMap(ObservableInternalHelper.flatMapIntoIterable(mapper));
    }

    @SchedulerSupport(value="none")
    public final <U, V> Observable<V> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends V> resultSelector) {
        return this.flatMap(ObservableInternalHelper.flatMapIntoIterable(mapper), resultSelector, false, Observable.bufferSize(), Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<U> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, int bufferSize) {
        return this.flatMap(ObservableInternalHelper.flatMapIntoIterable(mapper), false, bufferSize);
    }

    @SchedulerSupport(value="none")
    public final Disposable forEach(Consumer<? super T> onNext) {
        return this.subscribe(onNext);
    }

    @SchedulerSupport(value="none")
    public final Disposable forEachWhile(Predicate<? super T> onNext) {
        return this.forEachWhile(onNext, Functions.ERROR_CONSUMER, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final Disposable forEachWhile(Predicate<? super T> onNext, Consumer<? super Throwable> onError) {
        return this.forEachWhile(onNext, onError, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final Disposable forEachWhile(Predicate<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        ObjectHelper.requireNonNull(onNext, "onNext is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        ForEachWhileObserver<? super T> o = new ForEachWhileObserver<T>(onNext, onError, onComplete);
        this.subscribe(o);
        return o;
    }

    @SchedulerSupport(value="none")
    public final <K> Observable<GroupedObservable<K, T>> groupBy(Function<? super T, ? extends K> keySelector) {
        return this.groupBy(keySelector, Functions.identity(), false, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <K> Observable<GroupedObservable<K, T>> groupBy(Function<? super T, ? extends K> keySelector, boolean delayError) {
        return this.groupBy(keySelector, Functions.identity(), delayError, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <K, V> Observable<GroupedObservable<K, V>> groupBy(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        return this.groupBy(keySelector, valueSelector, false, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <K, V> Observable<GroupedObservable<K, V>> groupBy(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, boolean delayError) {
        return this.groupBy(keySelector, valueSelector, delayError, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <K, V> Observable<GroupedObservable<K, V>> groupBy(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, "valueSelector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableGroupBy<T, K, V>(this, keySelector, valueSelector, bufferSize, delayError));
    }

    @SchedulerSupport(value="none")
    public final <TRight, TLeftEnd, TRightEnd, R> Observable<R> groupJoin(ObservableSource<? extends TRight> other, Function<? super T, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super T, ? super Observable<TRight>, ? extends R> resultSelector) {
        return RxJavaPlugins.onAssembly(new ObservableGroupJoin(this, other, leftEnd, rightEnd, resultSelector));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> hide() {
        return RxJavaPlugins.onAssembly(new ObservableHide(this));
    }

    @SchedulerSupport(value="none")
    public final Completable ignoreElements() {
        return RxJavaPlugins.onAssembly(new ObservableIgnoreElementsCompletable(this));
    }

    @SchedulerSupport(value="none")
    public final Single<Boolean> isEmpty() {
        return this.all(Functions.alwaysFalse());
    }

    @SchedulerSupport(value="none")
    public final <TRight, TLeftEnd, TRightEnd, R> Observable<R> join(ObservableSource<? extends TRight> other, Function<? super T, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super T, ? super TRight, ? extends R> resultSelector) {
        return RxJavaPlugins.onAssembly(new ObservableJoin(this, other, leftEnd, rightEnd, resultSelector));
    }

    @SchedulerSupport(value="none")
    public final Maybe<T> lastElement() {
        return RxJavaPlugins.onAssembly(new ObservableLastMaybe(this));
    }

    @SchedulerSupport(value="none")
    public final Single<T> last(T defaultItem) {
        ObjectHelper.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new ObservableLastSingle<T>(this, defaultItem));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> lift(ObservableOperator<? extends R, ? super T> lifter) {
        ObjectHelper.requireNonNull(lifter, "onLift is null");
        return RxJavaPlugins.onAssembly(new ObservableLift<R, T>(this, lifter));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> map(Function<? super T, ? extends R> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableMap<T, R>(this, mapper));
    }

    @SchedulerSupport(value="none")
    public final Observable<Notification<T>> materialize() {
        return RxJavaPlugins.onAssembly(new ObservableMaterialize(this));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> mergeWith(ObservableSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Observable.merge(this, other);
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> observeOn(Scheduler scheduler) {
        return this.observeOn(scheduler, false, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> observeOn(Scheduler scheduler, boolean delayError) {
        return this.observeOn(scheduler, delayError, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> observeOn(Scheduler scheduler, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableObserveOn(this, scheduler, delayError, bufferSize));
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<U> ofType(Class<U> clazz) {
        ObjectHelper.requireNonNull(clazz, "clazz is null");
        return this.filter(Functions.isInstanceOf(clazz)).cast(clazz);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> onErrorResumeNext(Function<? super Throwable, ? extends ObservableSource<? extends T>> resumeFunction) {
        ObjectHelper.requireNonNull(resumeFunction, "resumeFunction is null");
        return RxJavaPlugins.onAssembly(new ObservableOnErrorNext(this, resumeFunction, false));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> onErrorResumeNext(ObservableSource<? extends T> next) {
        ObjectHelper.requireNonNull(next, "next is null");
        return this.onErrorResumeNext(Functions.justFunction(next));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> onErrorReturn(Function<? super Throwable, ? extends T> valueSupplier) {
        ObjectHelper.requireNonNull(valueSupplier, "valueSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableOnErrorReturn<T>(this, valueSupplier));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> onErrorReturnItem(T item) {
        ObjectHelper.requireNonNull(item, "item is null");
        return this.onErrorReturn(Functions.justFunction(item));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> onExceptionResumeNext(ObservableSource<? extends T> next) {
        ObjectHelper.requireNonNull(next, "next is null");
        return RxJavaPlugins.onAssembly(new ObservableOnErrorNext<T>(this, Functions.justFunction(next), true));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> onTerminateDetach() {
        return RxJavaPlugins.onAssembly(new ObservableDetach(this));
    }

    @SchedulerSupport(value="none")
    public final ConnectableObservable<T> publish() {
        return this.publish(Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> publish(Function<? super Observable<T>, ? extends ObservableSource<R>> selector) {
        return this.publish(selector, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> publish(Function<? super Observable<T>, ? extends ObservableSource<R>> selector, int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        ObjectHelper.requireNonNull(selector, "selector is null");
        return ObservablePublish.create(this, selector, bufferSize);
    }

    @SchedulerSupport(value="none")
    public final ConnectableObservable<T> publish(int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return ObservablePublish.create(this, bufferSize);
    }

    @SchedulerSupport(value="none")
    public final Maybe<T> reduce(BiFunction<T, T, T> reducer) {
        return this.scan(reducer).takeLast(1).singleElement();
    }

    @SchedulerSupport(value="none")
    public final <R> Single<R> reduce(R seed, BiFunction<R, ? super T, R> reducer) {
        return RxJavaPlugins.onAssembly(new ObservableSingleSingle<Object>(this.scan(seed, reducer).takeLast(1), null));
    }

    @SchedulerSupport(value="none")
    public final <R> Single<R> reduceWith(Callable<R> seedSupplier, BiFunction<R, ? super T, R> reducer) {
        return RxJavaPlugins.onAssembly(new ObservableSingleSingle<Object>(this.scanWith(seedSupplier, reducer).takeLast(1), null));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> repeat() {
        return this.repeat(Long.MAX_VALUE);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> repeat(long times) {
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        if (times == 0L) {
            return Observable.empty();
        }
        return RxJavaPlugins.onAssembly(new ObservableRepeat(this, times));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> repeatUntil(BooleanSupplier stop) {
        ObjectHelper.requireNonNull(stop, "stop is null");
        return RxJavaPlugins.onAssembly(new ObservableRepeatUntil(this, stop));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> repeatWhen(Function<? super Observable<Object>, ? extends ObservableSource<?>> handler) {
        ObjectHelper.requireNonNull(handler, "handler is null");
        return RxJavaPlugins.onAssembly(new ObservableRedo(this, ObservableInternalHelper.repeatWhenHandler(handler)));
    }

    @SchedulerSupport(value="none")
    public final ConnectableObservable<T> replay() {
        return ObservableReplay.createFrom(this);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> replay(Function<? super Observable<T>, ? extends ObservableSource<R>> selector) {
        ObjectHelper.requireNonNull(selector, "selector is null");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replayCallable(this), selector);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> replay(Function<? super Observable<T>, ? extends ObservableSource<R>> selector, int bufferSize) {
        ObjectHelper.requireNonNull(selector, "selector is null");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replayCallable(this, bufferSize), selector);
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final <R> Observable<R> replay(Function<? super Observable<T>, ? extends ObservableSource<R>> selector, int bufferSize, long time, TimeUnit unit) {
        return this.replay(selector, bufferSize, time, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public final <R> Observable<R> replay(Function<? super Observable<T>, ? extends ObservableSource<R>> selector, int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        ObjectHelper.requireNonNull(selector, "selector is null");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replayCallable(this, bufferSize, time, unit, scheduler), selector);
    }

    @SchedulerSupport(value="custom")
    public final <R> Observable<R> replay(Function<? super Observable<T>, ? extends ObservableSource<R>> selector, int bufferSize, Scheduler scheduler) {
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replayCallable(this, bufferSize), ObservableInternalHelper.replayFunction(selector, scheduler));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final <R> Observable<R> replay(Function<? super Observable<T>, ? extends ObservableSource<R>> selector, long time, TimeUnit unit) {
        return this.replay(selector, time, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public final <R> Observable<R> replay(Function<? super Observable<T>, ? extends ObservableSource<R>> selector, long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(selector, "selector is null");
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replayCallable(this, time, unit, scheduler), selector);
    }

    @SchedulerSupport(value="custom")
    public final <R> Observable<R> replay(Function<? super Observable<T>, ? extends ObservableSource<R>> selector, Scheduler scheduler) {
        ObjectHelper.requireNonNull(selector, "selector is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replayCallable(this), ObservableInternalHelper.replayFunction(selector, scheduler));
    }

    @SchedulerSupport(value="none")
    public final ConnectableObservable<T> replay(int bufferSize) {
        return ObservableReplay.create(this, bufferSize);
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final ConnectableObservable<T> replay(int bufferSize, long time, TimeUnit unit) {
        return this.replay(bufferSize, time, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public final ConnectableObservable<T> replay(int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.create(this, time, unit, scheduler, bufferSize);
    }

    @SchedulerSupport(value="custom")
    public final ConnectableObservable<T> replay(int bufferSize, Scheduler scheduler) {
        return ObservableReplay.observeOn(this.replay(bufferSize), scheduler);
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final ConnectableObservable<T> replay(long time, TimeUnit unit) {
        return this.replay(time, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public final ConnectableObservable<T> replay(long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.create(this, time, unit, scheduler);
    }

    @SchedulerSupport(value="custom")
    public final ConnectableObservable<T> replay(Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.observeOn(this.replay(), scheduler);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> retry() {
        return this.retry(Long.MAX_VALUE, Functions.alwaysTrue());
    }

    @SchedulerSupport(value="none")
    public final Observable<T> retry(BiPredicate<? super Integer, ? super Throwable> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableRetryBiPredicate(this, predicate));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> retry(long times) {
        return this.retry(times, Functions.alwaysTrue());
    }

    @SchedulerSupport(value="none")
    public final Observable<T> retry(long times, Predicate<? super Throwable> predicate) {
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableRetryPredicate(this, times, predicate));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> retry(Predicate<? super Throwable> predicate) {
        return this.retry(Long.MAX_VALUE, predicate);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> retryUntil(BooleanSupplier stop) {
        ObjectHelper.requireNonNull(stop, "stop is null");
        return this.retry(Long.MAX_VALUE, Functions.predicateReverseFor(stop));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> retryWhen(Function<? super Observable<? extends Throwable>, ? extends ObservableSource<?>> handler) {
        ObjectHelper.requireNonNull(handler, "handler is null");
        return RxJavaPlugins.onAssembly(new ObservableRedo(this, ObservableInternalHelper.retryWhenHandler(handler)));
    }

    @SchedulerSupport(value="none")
    public final void safeSubscribe(Observer<? super T> s) {
        ObjectHelper.requireNonNull(s, "s is null");
        if (s instanceof SafeObserver) {
            this.subscribe(s);
        } else {
            this.subscribe(new SafeObserver<T>(s));
        }
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> sample(long period, TimeUnit unit) {
        return this.sample(period, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> sample(long period, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableSampleTimed(this, period, unit, scheduler));
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<T> sample(ObservableSource<U> sampler) {
        ObjectHelper.requireNonNull(sampler, "sampler is null");
        return RxJavaPlugins.onAssembly(new ObservableSampleWithObservable(this, sampler));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> scan(BiFunction<T, T, T> accumulator) {
        ObjectHelper.requireNonNull(accumulator, "accumulator is null");
        return RxJavaPlugins.onAssembly(new ObservableScan<T>(this, accumulator));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> scan(R initialValue, BiFunction<R, ? super T, R> accumulator) {
        ObjectHelper.requireNonNull(initialValue, "seed is null");
        return this.scanWith(Functions.justCallable(initialValue), accumulator);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> scanWith(Callable<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        ObjectHelper.requireNonNull(seedSupplier, "seedSupplier is null");
        ObjectHelper.requireNonNull(accumulator, "accumulator is null");
        return RxJavaPlugins.onAssembly(new ObservableScanSeed<T, R>(this, seedSupplier, accumulator));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> serialize() {
        return RxJavaPlugins.onAssembly(new ObservableSerialized(this));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> share() {
        return this.publish().refCount();
    }

    @SchedulerSupport(value="none")
    public final Maybe<T> singleElement() {
        return RxJavaPlugins.onAssembly(new ObservableSingleMaybe(this));
    }

    @SchedulerSupport(value="none")
    public final Single<T> single(T defaultItem) {
        ObjectHelper.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new ObservableSingleSingle<T>(this, defaultItem));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> skip(long count) {
        if (count <= 0L) {
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new ObservableSkip(this, count));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> skip(long time, TimeUnit unit) {
        return this.skipUntil(Observable.timer(time, unit));
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> skip(long time, TimeUnit unit, Scheduler scheduler) {
        return this.skipUntil(Observable.timer(time, unit, scheduler));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> skipLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new ObservableSkipLast(this, count));
    }

    @SchedulerSupport(value="io.reactivex:trampoline")
    public final Observable<T> skipLast(long time, TimeUnit unit) {
        return this.skipLast(time, unit, Schedulers.trampoline(), false, Observable.bufferSize());
    }

    @SchedulerSupport(value="io.reactivex:trampoline")
    public final Observable<T> skipLast(long time, TimeUnit unit, boolean delayError) {
        return this.skipLast(time, unit, Schedulers.trampoline(), delayError, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler) {
        return this.skipLast(time, unit, scheduler, false, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        return this.skipLast(time, unit, scheduler, delayError, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new ObservableSkipLastTimed(this, time, unit, scheduler, s, delayError));
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<T> skipUntil(ObservableSource<U> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableSkipUntil(this, other));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> skipWhile(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableSkipWhile<T>(this, predicate));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> sorted() {
        return this.toList().toObservable().map(Functions.listSorter(Functions.naturalComparator())).flatMapIterable(Functions.identity());
    }

    @SchedulerSupport(value="none")
    public final Observable<T> sorted(Comparator<? super T> sortFunction) {
        return this.toList().toObservable().map(Functions.listSorter(sortFunction)).flatMapIterable(Functions.identity());
    }

    @SchedulerSupport(value="none")
    public final Observable<T> startWith(Iterable<? extends T> items) {
        return Observable.concatArray(Observable.fromIterable(items), this);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> startWith(ObservableSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Observable.concatArray(other, this);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> startWith(T item) {
        ObjectHelper.requireNonNull(item, "item is null");
        return Observable.concatArray(Observable.just(item), this);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> startWithArray(T ... items) {
        Observable<T> fromArray = Observable.fromArray(items);
        if (fromArray == Observable.empty()) {
            return RxJavaPlugins.onAssembly(this);
        }
        return Observable.concatArray(fromArray, this);
    }

    @SchedulerSupport(value="none")
    public final Disposable subscribe() {
        return this.subscribe(Functions.emptyConsumer(), Functions.ERROR_CONSUMER, Functions.EMPTY_ACTION, Functions.emptyConsumer());
    }

    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext) {
        return this.subscribe(onNext, Functions.ERROR_CONSUMER, Functions.EMPTY_ACTION, Functions.emptyConsumer());
    }

    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError) {
        return this.subscribe(onNext, onError, Functions.EMPTY_ACTION, Functions.emptyConsumer());
    }

    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        return this.subscribe(onNext, onError, onComplete, Functions.emptyConsumer());
    }

    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Consumer<? super Disposable> onSubscribe) {
        ObjectHelper.requireNonNull(onNext, "onNext is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        ObjectHelper.requireNonNull(onSubscribe, "onSubscribe is null");
        LambdaObserver<? super T> ls = new LambdaObserver<T>(onNext, onError, onComplete, onSubscribe);
        this.subscribe(ls);
        return ls;
    }

    @Override
    @SchedulerSupport(value="none")
    public final void subscribe(Observer<? super T> observer) {
        ObjectHelper.requireNonNull(observer, "observer is null");
        try {
            observer = RxJavaPlugins.onSubscribe(this, observer);
            ObjectHelper.requireNonNull(observer, "Plugin returned null Observer");
            this.subscribeActual(observer);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
            NullPointerException npe = new NullPointerException("Actually not, but can't throw other exceptions due to RS");
            npe.initCause(e);
            throw npe;
        }
    }

    protected abstract void subscribeActual(Observer<? super T> var1);

    @SchedulerSupport(value="none")
    public final <E extends Observer<? super T>> E subscribeWith(E observer) {
        this.subscribe(observer);
        return observer;
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> subscribeOn(Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableSubscribeOn(this, scheduler));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> switchIfEmpty(ObservableSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableSwitchIfEmpty<T>(this, other));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> switchMap(Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.switchMap(mapper, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> switchMap(Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (this instanceof ScalarCallable) {
            Object v = ((ScalarCallable)((Object)this)).call();
            if (v == null) {
                return Observable.empty();
            }
            return ObservableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new ObservableSwitchMap(this, mapper, bufferSize, false));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> switchMapDelayError(Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.switchMapDelayError(mapper, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> switchMapDelayError(Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (this instanceof ScalarCallable) {
            Object v = ((ScalarCallable)((Object)this)).call();
            if (v == null) {
                return Observable.empty();
            }
            return ObservableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new ObservableSwitchMap(this, mapper, bufferSize, true));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> take(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        return RxJavaPlugins.onAssembly(new ObservableTake(this, count));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> take(long time, TimeUnit unit) {
        return this.takeUntil(Observable.timer(time, unit));
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> take(long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeUntil(Observable.timer(time, unit, scheduler));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> takeFirst(Predicate<? super T> predicate) {
        return this.filter(predicate).take(1L);
    }

    @SchedulerSupport(value="none")
    public final Observable<T> takeLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return RxJavaPlugins.onAssembly(new ObservableIgnoreElements(this));
        }
        if (count == 1) {
            return RxJavaPlugins.onAssembly(new ObservableTakeLastOne(this));
        }
        return RxJavaPlugins.onAssembly(new ObservableTakeLast(this, count));
    }

    @SchedulerSupport(value="io.reactivex:trampoline")
    public final Observable<T> takeLast(long count, long time, TimeUnit unit) {
        return this.takeLast(count, time, unit, Schedulers.trampoline(), false, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> takeLast(long count, long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeLast(count, time, unit, scheduler, false, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> takeLast(long count, long time, TimeUnit unit, Scheduler scheduler, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (count < 0L) {
            throw new IndexOutOfBoundsException("count >= 0 required but it was " + count);
        }
        return RxJavaPlugins.onAssembly(new ObservableTakeLastTimed(this, count, time, unit, scheduler, bufferSize, delayError));
    }

    @SchedulerSupport(value="io.reactivex:trampoline")
    public final Observable<T> takeLast(long time, TimeUnit unit) {
        return this.takeLast(time, unit, Schedulers.trampoline(), false, Observable.bufferSize());
    }

    @SchedulerSupport(value="io.reactivex:trampoline")
    public final Observable<T> takeLast(long time, TimeUnit unit, boolean delayError) {
        return this.takeLast(time, unit, Schedulers.trampoline(), delayError, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeLast(time, unit, scheduler, false, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        return this.takeLast(time, unit, scheduler, delayError, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError, int bufferSize) {
        return this.takeLast(Long.MAX_VALUE, time, unit, scheduler, delayError, bufferSize);
    }

    @SchedulerSupport(value="none")
    public final <U> Observable<T> takeUntil(ObservableSource<U> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableTakeUntil(this, other));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> takeUntil(Predicate<? super T> stopPredicate) {
        ObjectHelper.requireNonNull(stopPredicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableTakeUntilPredicate<T>(this, stopPredicate));
    }

    @SchedulerSupport(value="none")
    public final Observable<T> takeWhile(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableTakeWhile<T>(this, predicate));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> throttleFirst(long windowDuration, TimeUnit unit) {
        return this.throttleFirst(windowDuration, unit, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> throttleFirst(long skipDuration, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableThrottleFirstTimed(this, skipDuration, unit, scheduler));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> throttleLast(long intervalDuration, TimeUnit unit) {
        return this.sample(intervalDuration, unit);
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> throttleLast(long intervalDuration, TimeUnit unit, Scheduler scheduler) {
        return this.sample(intervalDuration, unit, scheduler);
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> throttleWithTimeout(long timeout, TimeUnit unit) {
        return this.debounce(timeout, unit);
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> throttleWithTimeout(long timeout, TimeUnit unit, Scheduler scheduler) {
        return this.debounce(timeout, unit, scheduler);
    }

    @SchedulerSupport(value="none")
    public final Observable<Timed<T>> timeInterval() {
        return this.timeInterval(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @SchedulerSupport(value="none")
    public final Observable<Timed<T>> timeInterval(Scheduler scheduler) {
        return this.timeInterval(TimeUnit.MILLISECONDS, scheduler);
    }

    @SchedulerSupport(value="none")
    public final Observable<Timed<T>> timeInterval(TimeUnit unit) {
        return this.timeInterval(unit, Schedulers.computation());
    }

    @SchedulerSupport(value="none")
    public final Observable<Timed<T>> timeInterval(TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableTimeInterval(this, unit, scheduler));
    }

    @SchedulerSupport(value="none")
    public final <V> Observable<T> timeout(Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator) {
        return this.timeout0(null, itemTimeoutIndicator, null);
    }

    @SchedulerSupport(value="none")
    public final <V> Observable<T> timeout(Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator, ObservableSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return this.timeout0(null, itemTimeoutIndicator, other);
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> timeout(long timeout, TimeUnit timeUnit) {
        return this.timeout0(timeout, timeUnit, null, Schedulers.computation());
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<T> timeout(long timeout, TimeUnit timeUnit, ObservableSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return this.timeout0(timeout, timeUnit, other, Schedulers.computation());
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> timeout(long timeout, TimeUnit timeUnit, Scheduler scheduler, ObservableSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return this.timeout0(timeout, timeUnit, other, scheduler);
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> timeout(long timeout, TimeUnit timeUnit, Scheduler scheduler) {
        return this.timeout0(timeout, timeUnit, null, scheduler);
    }

    @SchedulerSupport(value="none")
    public final <U, V> Observable<T> timeout(ObservableSource<U> firstTimeoutIndicator, Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator) {
        ObjectHelper.requireNonNull(firstTimeoutIndicator, "firstTimeoutIndicator is null");
        return this.timeout0(firstTimeoutIndicator, itemTimeoutIndicator, null);
    }

    @SchedulerSupport(value="none")
    public final <U, V> Observable<T> timeout(ObservableSource<U> firstTimeoutIndicator, Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator, ObservableSource<? extends T> other) {
        ObjectHelper.requireNonNull(firstTimeoutIndicator, "firstTimeoutIndicator is null");
        ObjectHelper.requireNonNull(other, "other is null");
        return this.timeout0(firstTimeoutIndicator, itemTimeoutIndicator, other);
    }

    private Observable<T> timeout0(long timeout, TimeUnit timeUnit, ObservableSource<? extends T> other, Scheduler scheduler) {
        ObjectHelper.requireNonNull(timeUnit, "timeUnit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableTimeoutTimed<T>(this, timeout, timeUnit, scheduler, other));
    }

    private <U, V> Observable<T> timeout0(ObservableSource<U> firstTimeoutIndicator, Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator, ObservableSource<? extends T> other) {
        ObjectHelper.requireNonNull(itemTimeoutIndicator, "itemTimeoutIndicator is null");
        return RxJavaPlugins.onAssembly(new ObservableTimeout(this, firstTimeoutIndicator, itemTimeoutIndicator, other));
    }

    @SchedulerSupport(value="none")
    public final Observable<Timed<T>> timestamp() {
        return this.timestamp(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @SchedulerSupport(value="none")
    public final Observable<Timed<T>> timestamp(Scheduler scheduler) {
        return this.timestamp(TimeUnit.MILLISECONDS, scheduler);
    }

    @SchedulerSupport(value="none")
    public final Observable<Timed<T>> timestamp(TimeUnit unit) {
        return this.timestamp(unit, Schedulers.computation());
    }

    @SchedulerSupport(value="none")
    public final Observable<Timed<T>> timestamp(TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return this.map(Functions.timestampWith(unit, scheduler));
    }

    @SchedulerSupport(value="none")
    public final <R> R to(Function<? super Observable<T>, R> converter) {
        try {
            return converter.apply(this);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw ExceptionHelper.wrapOrThrow(ex);
        }
    }

    @SchedulerSupport(value="none")
    public final Single<List<T>> toList() {
        return this.toList(16);
    }

    @SchedulerSupport(value="none")
    public final Single<List<T>> toList(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return RxJavaPlugins.onAssembly(new ObservableToListSingle(this, capacityHint));
    }

    @SchedulerSupport(value="none")
    public final <U extends Collection<? super T>> Single<U> toList(Callable<U> collectionSupplier) {
        ObjectHelper.requireNonNull(collectionSupplier, "collectionSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableToListSingle(this, collectionSupplier));
    }

    @SchedulerSupport(value="none")
    public final <K> Single<Map<K, T>> toMap(Function<? super T, ? extends K> keySelector) {
        return this.collect(HashMapSupplier.asCallable(), Functions.toMapKeySelector(keySelector));
    }

    @SchedulerSupport(value="none")
    public final <K, V> Single<Map<K, V>> toMap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, "valueSelector is null");
        return this.collect(HashMapSupplier.asCallable(), Functions.toMapKeyValueSelector(keySelector, valueSelector));
    }

    @SchedulerSupport(value="none")
    public final <K, V> Single<Map<K, V>> toMap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Callable<? extends Map<K, V>> mapSupplier) {
        return this.collect(mapSupplier, Functions.toMapKeyValueSelector(keySelector, valueSelector));
    }

    @SchedulerSupport(value="none")
    public final <K> Single<Map<K, Collection<T>>> toMultimap(Function<? super T, ? extends K> keySelector) {
        Function valueSelector = Functions.identity();
        Callable mapSupplier = HashMapSupplier.asCallable();
        Function collectionFactory = ArrayListSupplier.asFunction();
        return this.toMultimap(keySelector, valueSelector, mapSupplier, collectionFactory);
    }

    @SchedulerSupport(value="none")
    public final <K, V> Single<Map<K, Collection<V>>> toMultimap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        Callable mapSupplier = HashMapSupplier.asCallable();
        Function collectionFactory = ArrayListSupplier.asFunction();
        return this.toMultimap(keySelector, valueSelector, mapSupplier, collectionFactory);
    }

    @SchedulerSupport(value="none")
    public final <K, V> Single<Map<K, Collection<V>>> toMultimap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Callable<? extends Map<K, Collection<V>>> mapSupplier, Function<? super K, ? extends Collection<? super V>> collectionFactory) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, "valueSelector is null");
        ObjectHelper.requireNonNull(mapSupplier, "mapSupplier is null");
        ObjectHelper.requireNonNull(collectionFactory, "collectionFactory is null");
        return this.collect(mapSupplier, Functions.toMultimapKeyValueSelector(keySelector, valueSelector, collectionFactory));
    }

    @SchedulerSupport(value="none")
    public final <K, V> Single<Map<K, Collection<V>>> toMultimap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Callable<Map<K, Collection<V>>> mapSupplier) {
        return this.toMultimap(keySelector, valueSelector, mapSupplier, ArrayListSupplier.asFunction());
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> toFlowable(BackpressureStrategy strategy) {
        FlowableFromObservable o = new FlowableFromObservable(this);
        switch (strategy) {
            case DROP: {
                return o.onBackpressureDrop();
            }
            case LATEST: {
                return o.onBackpressureLatest();
            }
        }
        return o.onBackpressureBuffer();
    }

    @SchedulerSupport(value="none")
    public final Single<List<T>> toSortedList() {
        return this.toSortedList(Functions.naturalOrder());
    }

    @SchedulerSupport(value="none")
    public final Single<List<T>> toSortedList(Comparator<? super T> comparator) {
        ObjectHelper.requireNonNull(comparator, "comparator is null");
        return this.toList().map(Functions.listSorter(comparator));
    }

    @SchedulerSupport(value="none")
    public final Single<List<T>> toSortedList(Comparator<? super T> comparator, int capacityHint) {
        ObjectHelper.requireNonNull(comparator, "comparator is null");
        return this.toList(capacityHint).map(Functions.listSorter(comparator));
    }

    @SchedulerSupport(value="none")
    public final Single<List<T>> toSortedList(int capacityHint) {
        return this.toSortedList(Functions.naturalOrder(), capacityHint);
    }

    @SchedulerSupport(value="custom")
    public final Observable<T> unsubscribeOn(Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableUnsubscribeOn(this, scheduler));
    }

    @SchedulerSupport(value="none")
    public final Observable<Observable<T>> window(long count) {
        return this.window(count, count, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final Observable<Observable<T>> window(long count, long skip) {
        return this.window(count, skip, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final Observable<Observable<T>> window(long count, long skip, int bufferSize) {
        ObjectHelper.verifyPositive(count, "count");
        ObjectHelper.verifyPositive(skip, "skip");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableWindow(this, count, skip, bufferSize));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<Observable<T>> window(long timespan, long timeskip, TimeUnit unit) {
        return this.window(timespan, timeskip, unit, Schedulers.computation(), Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<Observable<T>> window(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler) {
        return this.window(timespan, timeskip, unit, scheduler, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<Observable<T>> window(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, int bufferSize) {
        ObjectHelper.verifyPositive(timespan, "timespan");
        ObjectHelper.verifyPositive(timeskip, "timeskip");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.requireNonNull(unit, "unit is null");
        return RxJavaPlugins.onAssembly(new ObservableWindowTimed(this, timespan, timeskip, unit, scheduler, Long.MAX_VALUE, bufferSize, false));
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<Observable<T>> window(long timespan, TimeUnit unit) {
        return this.window(timespan, unit, Schedulers.computation(), Long.MAX_VALUE, false);
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<Observable<T>> window(long timespan, TimeUnit unit, long count) {
        return this.window(timespan, unit, Schedulers.computation(), count, false);
    }

    @SchedulerSupport(value="io.reactivex:computation")
    public final Observable<Observable<T>> window(long timespan, TimeUnit unit, long count, boolean restart) {
        return this.window(timespan, unit, Schedulers.computation(), count, restart);
    }

    @SchedulerSupport(value="custom")
    public final Observable<Observable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler) {
        return this.window(timespan, unit, scheduler, Long.MAX_VALUE, false);
    }

    @SchedulerSupport(value="custom")
    public final Observable<Observable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler, long count) {
        return this.window(timespan, unit, scheduler, count, false);
    }

    @SchedulerSupport(value="custom")
    public final Observable<Observable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler, long count, boolean restart) {
        return this.window(timespan, unit, scheduler, count, restart, Observable.bufferSize());
    }

    @SchedulerSupport(value="custom")
    public final Observable<Observable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler, long count, boolean restart, int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.verifyPositive(count, "count");
        return RxJavaPlugins.onAssembly(new ObservableWindowTimed(this, timespan, timespan, unit, scheduler, count, bufferSize, restart));
    }

    @SchedulerSupport(value="none")
    public final <B> Observable<Observable<T>> window(ObservableSource<B> boundary) {
        return this.window(boundary, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <B> Observable<Observable<T>> window(ObservableSource<B> boundary, int bufferSize) {
        ObjectHelper.requireNonNull(boundary, "boundary is null");
        return RxJavaPlugins.onAssembly(new ObservableWindowBoundary(this, boundary, bufferSize));
    }

    @SchedulerSupport(value="none")
    public final <U, V> Observable<Observable<T>> window(ObservableSource<U> openingIndicator, Function<? super U, ? extends ObservableSource<V>> closingIndicator) {
        return this.window(openingIndicator, closingIndicator, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <U, V> Observable<Observable<T>> window(ObservableSource<U> openingIndicator, Function<? super U, ? extends ObservableSource<V>> closingIndicator, int bufferSize) {
        ObjectHelper.requireNonNull(openingIndicator, "openingIndicator is null");
        ObjectHelper.requireNonNull(closingIndicator, "closingIndicator is null");
        return RxJavaPlugins.onAssembly(new ObservableWindowBoundarySelector(this, openingIndicator, closingIndicator, bufferSize));
    }

    @SchedulerSupport(value="none")
    public final <B> Observable<Observable<T>> window(Callable<? extends ObservableSource<B>> boundary) {
        return this.window(boundary, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final <B> Observable<Observable<T>> window(Callable<? extends ObservableSource<B>> boundary, int bufferSize) {
        ObjectHelper.requireNonNull(boundary, "boundary is null");
        return RxJavaPlugins.onAssembly(new ObservableWindowBoundarySupplier(this, boundary, bufferSize));
    }

    @SchedulerSupport(value="none")
    public final <U, R> Observable<R> withLatestFrom(ObservableSource<? extends U> other, BiFunction<? super T, ? super U, ? extends R> combiner) {
        ObjectHelper.requireNonNull(other, "other is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new ObservableWithLatestFrom<T, U, R>(this, combiner, other));
    }

    @SchedulerSupport(value="none")
    public final <T1, T2, R> Observable<R> withLatestFrom(ObservableSource<T1> o1, ObservableSource<T2> o2, Function3<? super T, ? super T1, ? super T2, R> combiner) {
        ObjectHelper.requireNonNull(o1, "o1 is null");
        ObjectHelper.requireNonNull(o2, "o2 is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new ObservableSource[]{o1, o2}, f);
    }

    @SchedulerSupport(value="none")
    public final <T1, T2, T3, R> Observable<R> withLatestFrom(ObservableSource<T1> o1, ObservableSource<T2> o2, ObservableSource<T3> o3, Function4<? super T, ? super T1, ? super T2, ? super T3, R> combiner) {
        ObjectHelper.requireNonNull(o1, "o1 is null");
        ObjectHelper.requireNonNull(o2, "o2 is null");
        ObjectHelper.requireNonNull(o3, "o3 is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new ObservableSource[]{o1, o2, o3}, f);
    }

    @SchedulerSupport(value="none")
    public final <T1, T2, T3, T4, R> Observable<R> withLatestFrom(ObservableSource<T1> o1, ObservableSource<T2> o2, ObservableSource<T3> o3, ObservableSource<T4> o4, Function5<? super T, ? super T1, ? super T2, ? super T3, ? super T4, R> combiner) {
        ObjectHelper.requireNonNull(o1, "o1 is null");
        ObjectHelper.requireNonNull(o2, "o2 is null");
        ObjectHelper.requireNonNull(o3, "o3 is null");
        ObjectHelper.requireNonNull(o4, "o4 is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new ObservableSource[]{o1, o2, o3, o4}, f);
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> withLatestFrom(ObservableSource<?>[] others, Function<? super Object[], R> combiner) {
        ObjectHelper.requireNonNull(others, "others is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new ObservableWithLatestFromMany(this, others, combiner));
    }

    @SchedulerSupport(value="none")
    public final <R> Observable<R> withLatestFrom(Iterable<? extends ObservableSource<?>> others, Function<? super Object[], R> combiner) {
        ObjectHelper.requireNonNull(others, "others is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new ObservableWithLatestFromMany(this, others, combiner));
    }

    @SchedulerSupport(value="none")
    public final <U, R> Observable<R> zipWith(Iterable<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        ObjectHelper.requireNonNull(other, "other is null");
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        return RxJavaPlugins.onAssembly(new ObservableZipIterable<T, U, R>(this, other, zipper));
    }

    @SchedulerSupport(value="none")
    public final <U, R> Observable<R> zipWith(ObservableSource<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Observable.zip(this, other, zipper);
    }

    @SchedulerSupport(value="none")
    public final <U, R> Observable<R> zipWith(ObservableSource<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper, boolean delayError) {
        return Observable.zip(this, other, zipper, delayError);
    }

    @SchedulerSupport(value="none")
    public final <U, R> Observable<R> zipWith(ObservableSource<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper, boolean delayError, int bufferSize) {
        return Observable.zip(this, other, zipper, delayError, bufferSize);
    }

    @SchedulerSupport(value="none")
    public final TestObserver<T> test() {
        TestObserver ts = new TestObserver();
        this.subscribe(ts);
        return ts;
    }

    @SchedulerSupport(value="none")
    public final TestObserver<T> test(boolean dispose) {
        TestObserver ts = new TestObserver();
        if (dispose) {
            ts.dispose();
        }
        this.subscribe(ts);
        return ts;
    }
}

