/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.ArrayCompositeSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTakeUntil<T, U>
extends AbstractFlowableWithUpstream<T, T> {
    final Publisher<? extends U> other;

    public FlowableTakeUntil(Publisher<T> source, Publisher<? extends U> other) {
        super(source);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> serial = new SerializedSubscriber<T>(child);
        final ArrayCompositeSubscription frc = new ArrayCompositeSubscription(2);
        final TakeUntilSubscriber<? super T> tus = new TakeUntilSubscriber<T>(serial, frc);
        this.other.subscribe(new Subscriber<U>(){

            public void onSubscribe(Subscription s) {
                if (frc.setResource(1, s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(U t) {
                frc.dispose();
                if (tus.compareAndSet(false, true)) {
                    EmptySubscription.complete(serial);
                } else {
                    serial.onComplete();
                }
            }

            public void onError(Throwable t) {
                frc.dispose();
                if (tus.compareAndSet(false, true)) {
                    EmptySubscription.error(t, serial);
                } else {
                    serial.onError(t);
                }
            }

            public void onComplete() {
                frc.dispose();
                if (tus.compareAndSet(false, true)) {
                    EmptySubscription.complete(serial);
                } else {
                    serial.onComplete();
                }
            }
        });
        this.source.subscribe(tus);
    }

    static final class TakeUntilSubscriber<T>
    extends AtomicBoolean
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = 3451719290311127173L;
        final Subscriber<? super T> actual;
        final ArrayCompositeSubscription frc;
        Subscription s;

        TakeUntilSubscriber(Subscriber<? super T> actual, ArrayCompositeSubscription frc) {
            this.actual = actual;
            this.frc = frc;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                if (this.frc.setResource(0, s) && this.compareAndSet(false, true)) {
                    this.actual.onSubscribe((Subscription)this);
                }
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.frc.dispose();
            this.actual.onError(t);
        }

        public void onComplete() {
            this.frc.dispose();
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.frc.dispose();
        }
    }
}

