/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class MaybeFromFuture<T>
extends Maybe<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public MaybeFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        T v;
        Disposable d = Disposables.empty();
        observer.onSubscribe(d);
        if (d.isDisposed()) {
            return;
        }
        try {
            v = this.timeout <= 0L ? this.future.get() : this.future.get(this.timeout, this.unit);
        }
        catch (InterruptedException ex) {
            if (d.isDisposed()) {
                return;
            }
            observer.onError(ex);
            return;
        }
        catch (ExecutionException ex) {
            if (d.isDisposed()) {
                return;
            }
            observer.onError(ex.getCause());
            return;
        }
        catch (TimeoutException ex) {
            if (d.isDisposed()) {
                return;
            }
            observer.onError(ex);
            return;
        }
        if (d.isDisposed()) {
            return;
        }
        if (v == null) {
            observer.onComplete();
        } else {
            observer.onSuccess(v);
        }
    }
}

