/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.observers.BlockingObserver;
import io.reactivex.internal.observers.LambdaObserver;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.observers.DefaultObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;

public enum ObservableBlockingSubscribe {


    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> void subscribe(ObservableSource<? extends T> o, Observer<? super T> subscriber) {
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BlockingObserver bs = new BlockingObserver((Queue<Object>)queue);
        o.subscribe(bs);
        try {
            Object v;
            do {
                if (bs.isDisposed()) {
                    return;
                }
                v = queue.poll();
                if (v == null) {
                    if (bs.isDisposed()) {
                        return;
                    }
                    v = queue.take();
                }
                if (bs.isDisposed()) {
                    return;
                }
                if (o != BlockingObserver.TERMINATED) continue;
                return;
            } while (!NotificationLite.acceptFull(v, subscriber));
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            subscriber.onError(e);
            return;
        }
        finally {
            bs.dispose();
        }
    }

    public static <T> void subscribe(ObservableSource<? extends T> o) {
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] error = new Throwable[]{null};
        LambdaObserver ls = new LambdaObserver(Functions.emptyConsumer(), (Consumer<? super Throwable>)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable e) {
                error[0] = e;
                cdl.countDown();
            }
        }, new Action(){

            @Override
            public void run() {
                cdl.countDown();
            }
        }, (Consumer<? super Disposable>)new Consumer<Disposable>(){

            @Override
            public void accept(Disposable s) {
            }
        });
        o.subscribe(ls);
        BlockingHelper.awaitForComplete(cdl, ls);
        Throwable e = error[0];
        if (e != null) {
            throw ExceptionHelper.wrapOrThrow(e);
        }
    }

    public static <T> void subscribe(ObservableSource<? extends T> o, final Consumer<? super T> onNext, final Consumer<? super Throwable> onError, final Action onComplete) {
        ObservableBlockingSubscribe.subscribe(o, new DefaultObserver<T>(){
            boolean done;

            @Override
            public void onNext(T t) {
                if (this.done) {
                    return;
                }
                try {
                    onNext.accept(t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.cancel();
                    this.onError(ex);
                }
            }

            @Override
            public void onError(Throwable e) {
                if (this.done) {
                    RxJavaPlugins.onError(e);
                    return;
                }
                this.done = true;
                try {
                    onError.accept(e);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }

            @Override
            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                try {
                    onComplete.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        });
    }
}

