/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.observers.BasicFuseableObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableDistinctUntilChanged<T>
extends AbstractObservableWithUpstream<T, T> {
    final BiPredicate<? super T, ? super T> comparer;

    public ObservableDistinctUntilChanged(ObservableSource<T> source, BiPredicate<? super T, ? super T> comparer) {
        super(source);
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(Observer<? super T> s) {
        this.source.subscribe(new DistinctUntilChangedObserver<T>(s, this.comparer));
    }

    static final class DistinctUntilChangedObserver<T>
    extends BasicFuseableObserver<T, T> {
        final BiPredicate<? super T, ? super T> comparer;
        T last;
        boolean hasValue;

        DistinctUntilChangedObserver(Observer<? super T> actual, BiPredicate<? super T, ? super T> comparer) {
            super(actual);
            this.comparer = comparer;
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(t);
                return;
            }
            if (this.hasValue) {
                boolean equal;
                try {
                    equal = this.comparer.test(this.last, t);
                }
                catch (Throwable ex) {
                    this.fail(ex);
                    return;
                }
                this.last = t;
                if (equal) {
                    return;
                }
                this.actual.onNext(t);
                return;
            }
            this.hasValue = true;
            this.last = t;
            this.actual.onNext(t);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        public T poll() throws Exception {
            Object v;
            while ((v = this.qs.poll()) != null) {
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = v;
                    return v;
                }
                if (!this.comparer.test(this.last, v)) {
                    this.last = v;
                    return v;
                }
                this.last = v;
            }
            return null;
        }
    }
}

