/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.fuseable.HasUpstreamObservableSource;
import io.reactivex.internal.operators.observable.ObserverResourceWrapper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Timed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableReplay<T>
extends ConnectableObservable<T>
implements HasUpstreamObservableSource<T> {
    final ObservableSource<T> source;
    final AtomicReference<ReplayObserver<T>> current;
    final Callable<? extends ReplayBuffer<T>> bufferFactory;
    final ObservableSource<T> onSubscribe;
    static final Callable DEFAULT_UNBOUNDED_FACTORY = new Callable(){

        public Object call() {
            return new UnboundedReplayBuffer(16);
        }
    };

    public static <U, R> Observable<R> multicastSelector(final Callable<? extends ConnectableObservable<U>> connectableFactory, final Function<? super Observable<U>, ? extends ObservableSource<R>> selector) {
        return RxJavaPlugins.onAssembly(new Observable<R>(){

            @Override
            protected void subscribeActual(Observer<? super R> child) {
                ObservableSource observable;
                ConnectableObservable co;
                try {
                    co = (ConnectableObservable)connectableFactory.call();
                    observable = (ObservableSource)selector.apply(co);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    EmptyDisposable.error(e, child);
                    return;
                }
                final ObserverResourceWrapper srw = new ObserverResourceWrapper(child);
                observable.subscribe(srw);
                co.connect((Consumer<Disposable>)new Consumer<Disposable>(){

                    @Override
                    public void accept(Disposable r) {
                        srw.setResource(r);
                    }
                });
            }
        });
    }

    public static <T> ConnectableObservable<T> observeOn(final ConnectableObservable<T> co, Scheduler scheduler) {
        final Observable observable = co.observeOn(scheduler);
        return RxJavaPlugins.onAssembly(new ConnectableObservable<T>(){

            @Override
            public void connect(Consumer<? super Disposable> connection) {
                co.connect(connection);
            }

            @Override
            protected void subscribeActual(Observer<? super T> observer) {
                observable.subscribe(observer);
            }
        });
    }

    public static <T> ConnectableObservable<T> createFrom(ObservableSource<? extends T> source) {
        return ObservableReplay.create(source, DEFAULT_UNBOUNDED_FACTORY);
    }

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source, final int bufferSize) {
        if (bufferSize == Integer.MAX_VALUE) {
            return ObservableReplay.createFrom(source);
        }
        return ObservableReplay.create(source, new Callable<ReplayBuffer<T>>(){

            @Override
            public ReplayBuffer<T> call() {
                return new SizeBoundReplayBuffer(bufferSize);
            }
        });
    }

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source, long maxAge, TimeUnit unit, Scheduler scheduler) {
        return ObservableReplay.create(source, maxAge, unit, scheduler, Integer.MAX_VALUE);
    }

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source, final long maxAge, final TimeUnit unit, final Scheduler scheduler, final int bufferSize) {
        return ObservableReplay.create(source, new Callable<ReplayBuffer<T>>(){

            @Override
            public ReplayBuffer<T> call() {
                return new SizeAndTimeBoundReplayBuffer(bufferSize, maxAge, unit, scheduler);
            }
        });
    }

    static <T> ConnectableObservable<T> create(ObservableSource<T> source, final Callable<? extends ReplayBuffer<T>> bufferFactory) {
        final AtomicReference<ReplayObserver<T>> curr = new AtomicReference<ReplayObserver<T>>();
        ObservableSource onSubscribe = new ObservableSource<T>(){

            @Override
            public void subscribe(Observer<? super T> child) {
                ReplayObserver r;
                while ((r = (ReplayObserver)curr.get()) == null) {
                    ReplayBuffer buf;
                    try {
                        buf = (ReplayBuffer)bufferFactory.call();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        throw ExceptionHelper.wrapOrThrow(ex);
                    }
                    ReplayObserver u = new ReplayObserver(buf);
                    if (!curr.compareAndSet(null, u)) continue;
                    r = u;
                    break;
                }
                InnerDisposable inner = new InnerDisposable(r, child);
                r.add(inner);
                child.onSubscribe(inner);
                r.buffer.replay(inner);
            }
        };
        return RxJavaPlugins.onAssembly(new ObservableReplay<T>(onSubscribe, source, curr, bufferFactory));
    }

    private ObservableReplay(ObservableSource<T> onSubscribe, ObservableSource<T> source, AtomicReference<ReplayObserver<T>> current, Callable<? extends ReplayBuffer<T>> bufferFactory) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public ObservableSource<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.onSubscribe.subscribe(observer);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        ReplayObserver<T> ps;
        while ((ps = this.current.get()) == null || ps.isDisposed()) {
            ReplayBuffer<T> buf;
            try {
                buf = this.bufferFactory.call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                throw ExceptionHelper.wrapOrThrow(ex);
            }
            ReplayObserver<T> u = new ReplayObserver<T>(buf);
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (doConnect) {
            this.source.subscribe(ps);
        }
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = 3457957419649567404L;
        final Scheduler scheduler;
        final long maxAge;
        final TimeUnit unit;
        final int limit;

        SizeAndTimeBoundReplayBuffer(int limit, long maxAge, TimeUnit unit, Scheduler scheduler) {
            this.scheduler = scheduler;
            this.limit = limit;
            this.maxAge = maxAge;
            this.unit = unit;
        }

        @Override
        Object enterTransform(Object value) {
            return new Timed<Object>(value, this.scheduler.now(this.unit), this.unit);
        }

        @Override
        Object leaveTransform(Object value) {
            return ((Timed)value).value();
        }

        @Override
        void truncate() {
            long timeLimit = this.scheduler.now(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            Node next = (Node)prev.get();
            int e = 0;
            while (next != null) {
                if (this.size > this.limit) {
                    ++e;
                    --this.size;
                    prev = next;
                    next = (Node)next.get();
                    continue;
                }
                Timed v = (Timed)next.value;
                if (v.time() > timeLimit) break;
                ++e;
                --this.size;
                prev = next;
                next = (Node)next.get();
            }
            if (e != 0) {
                this.setFirst(prev);
            }
        }

        @Override
        void truncateFinal() {
            Timed v;
            long timeLimit = this.scheduler.now(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            int e = 0;
            for (Node next = (Node)prev.get(); next != null && this.size > 1 && (v = (Timed)next.value).time() <= timeLimit; next = (Node)next.get()) {
                ++e;
                --this.size;
                prev = next;
            }
            if (e != 0) {
                this.setFirst(prev);
            }
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = -5898283885385201806L;
        final int limit;

        SizeBoundReplayBuffer(int limit) {
            this.limit = limit;
        }

        @Override
        void truncate() {
            if (this.size > this.limit) {
                this.removeFirst();
            }
        }
    }

    static class BoundedReplayBuffer<T>
    extends AtomicReference<Node>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 2346567790059478686L;
        Node tail;
        int size;

        BoundedReplayBuffer() {
            Node n;
            this.tail = n = new Node((Object)null);
            this.set(n);
        }

        final void addLast(Node n) {
            this.tail.set(n);
            this.tail = n;
            ++this.size;
        }

        final void removeFirst() {
            Node head = (Node)this.get();
            Node next = (Node)head.get();
            if (next == null) {
                throw new IllegalStateException("Empty list!");
            }
            --this.size;
            this.setFirst(next);
        }

        final void removeSome(int n) {
            Node head = (Node)this.get();
            while (n > 0) {
                head = (Node)head.get();
                --n;
                --this.size;
            }
            this.setFirst(head);
        }

        final void setFirst(Node n) {
            this.set(n);
        }

        @Override
        public final void next(T value) {
            Object o = this.enterTransform(NotificationLite.next(value));
            Node n = new Node(o);
            this.addLast(n);
            this.truncate();
        }

        @Override
        public final void error(Throwable e) {
            Object o = this.enterTransform(NotificationLite.error(e));
            Node n = new Node(o);
            this.addLast(n);
            this.truncateFinal();
        }

        @Override
        public final void complete() {
            Object o = this.enterTransform(NotificationLite.complete());
            Node n = new Node(o);
            this.addLast(n);
            this.truncateFinal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void replay(InnerDisposable<T> output) {
            InnerDisposable<T> innerDisposable = output;
            synchronized (innerDisposable) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            while (!output.isDisposed()) {
                Node v;
                Node node = (Node)output.index();
                if (node == null) {
                    node = (Node)this.get();
                    output.index = node;
                }
                while ((v = (Node)node.get()) != null) {
                    Object o = this.leaveTransform(v.value);
                    try {
                        if (NotificationLite.accept(o, output.child)) {
                            output.index = null;
                            return;
                        }
                    }
                    catch (Throwable err) {
                        Exceptions.throwIfFatal(err);
                        output.index = null;
                        output.dispose();
                        if (!NotificationLite.isError(o) && !NotificationLite.isComplete(o)) {
                            output.child.onError(err);
                        }
                        return;
                    }
                    node = v;
                    if (!output.isDisposed()) continue;
                    return;
                }
                output.index = node;
                InnerDisposable<T> innerDisposable2 = output;
                synchronized (innerDisposable2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }

        Object enterTransform(Object value) {
            return value;
        }

        Object leaveTransform(Object value) {
            return value;
        }

        void truncate() {
        }

        void truncateFinal() {
        }

        final void collect(Collection<? super T> output) {
            Object o;
            Object v;
            Node next;
            Node n = (Node)this.get();
            while ((next = (Node)n.get()) != null && !NotificationLite.isComplete(v = this.leaveTransform(o = next.value)) && !NotificationLite.isError(v)) {
                output.add(NotificationLite.getValue(v));
                n = next;
            }
        }

        boolean hasError() {
            return this.tail.value != null && NotificationLite.isError(this.leaveTransform(this.tail.value));
        }

        boolean hasCompleted() {
            return this.tail.value != null && NotificationLite.isComplete(this.leaveTransform(this.tail.value));
        }
    }

    static final class Node
    extends AtomicReference<Node> {
        private static final long serialVersionUID = 245354315435971818L;
        final Object value;

        Node(Object value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends ArrayList<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 7063189396499112664L;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            super(capacityHint);
        }

        @Override
        public void next(T value) {
            this.add(NotificationLite.next(value));
            ++this.size;
        }

        @Override
        public void error(Throwable e) {
            this.add(NotificationLite.error(e));
            ++this.size;
        }

        @Override
        public void complete() {
            this.add(NotificationLite.complete());
            ++this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replay(InnerDisposable<T> output) {
            InnerDisposable<T> innerDisposable = output;
            synchronized (innerDisposable) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            Observer child = output.child;
            while (!output.isDisposed()) {
                int destinationIndex;
                int sourceIndex = this.size;
                Integer destinationIndexObject = (Integer)output.index();
                int n = destinationIndex = destinationIndexObject != null ? destinationIndexObject : 0;
                while (destinationIndex < sourceIndex) {
                    Object o = this.get(destinationIndex);
                    try {
                        if (NotificationLite.accept(o, child)) {
                            return;
                        }
                    }
                    catch (Throwable err) {
                        Exceptions.throwIfFatal(err);
                        output.dispose();
                        if (!NotificationLite.isError(o) && !NotificationLite.isComplete(o)) {
                            child.onError(err);
                        }
                        return;
                    }
                    if (output.isDisposed()) {
                        return;
                    }
                    ++destinationIndex;
                }
                output.index = destinationIndex;
                InnerDisposable<T> innerDisposable2 = output;
                synchronized (innerDisposable2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }
    }

    static interface ReplayBuffer<T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(InnerDisposable<T> var1);
    }

    static final class InnerDisposable<T>
    implements Disposable {
        final ReplayObserver<T> parent;
        final Observer<? super T> child;
        Object index;
        boolean emitting;
        boolean missed;
        volatile boolean cancelled;

        InnerDisposable(ReplayObserver<T> parent, Observer<? super T> child) {
            this.parent = parent;
            this.child = child;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.parent.remove(this);
            }
        }

        <U> U index() {
            return (U)this.index;
        }
    }

    static final class ReplayObserver<T>
    implements Observer<T>,
    Disposable {
        final ReplayBuffer<T> buffer;
        boolean done;
        static final InnerDisposable[] EMPTY = new InnerDisposable[0];
        static final InnerDisposable[] TERMINATED = new InnerDisposable[0];
        final AtomicReference<InnerDisposable[]> observers;
        final AtomicBoolean shouldConnect;
        volatile Disposable subscription;

        ReplayObserver(ReplayBuffer<T> buffer) {
            this.buffer = buffer;
            this.observers = new AtomicReference<InnerDisposable[]>(EMPTY);
            this.shouldConnect = new AtomicBoolean();
        }

        @Override
        public boolean isDisposed() {
            return this.observers.get() == TERMINATED;
        }

        @Override
        public void dispose() {
            this.observers.set(TERMINATED);
            this.subscription.dispose();
        }

        boolean add(InnerDisposable<T> producer) {
            InnerDisposable[] u;
            InnerDisposable[] c;
            if (producer == null) {
                throw new NullPointerException();
            }
            do {
                if ((c = this.observers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerDisposable[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.observers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerDisposable<T> producer) {
            InnerDisposable[] u;
            InnerDisposable[] c;
            do {
                if ((c = this.observers.get()) == EMPTY || c == TERMINATED) {
                    return;
                }
                int j = -1;
                int len = c.length;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                    continue;
                }
                u = new InnerDisposable[len - 1];
                System.arraycopy(c, 0, u, 0, j);
                System.arraycopy(c, j + 1, u, j, len - j - 1);
            } while (!this.observers.compareAndSet(c, u));
        }

        @Override
        public void onSubscribe(Disposable p) {
            if (DisposableHelper.validate(this.subscription, p)) {
                this.subscription = p;
                this.replay();
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.done) {
                this.buffer.next(t);
                this.replay();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            if (!this.done) {
                this.done = true;
                try {
                    this.buffer.error(e);
                    this.replay();
                }
                finally {
                    this.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                try {
                    this.buffer.complete();
                    this.replay();
                }
                finally {
                    this.dispose();
                }
            }
        }

        void replay() {
            InnerDisposable[] a;
            for (InnerDisposable rp : a = this.observers.get()) {
                this.buffer.replay(rp);
            }
        }
    }
}

