/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import java.util.NoSuchElementException;

public final class SingleFromObservable<T>
extends Single<T> {
    final Observable<T> upstream;
    final T defaultValue;

    public SingleFromObservable(Observable<T> upstream, T defaultValue) {
        this.upstream = upstream;
        this.defaultValue = defaultValue;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        this.upstream.subscribe(new Observer<T>(){
            T last;
            boolean done;

            @Override
            public void onSubscribe(Disposable d) {
                s.onSubscribe(d);
            }

            @Override
            public void onNext(T value) {
                if (this.last == null) {
                    this.last = value;
                } else {
                    s.onError(new IndexOutOfBoundsException());
                    this.done = true;
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!this.done) {
                    s.onError(e);
                }
            }

            @Override
            public void onComplete() {
                Object v = this.last;
                this.last = null;
                if (v != null) {
                    s.onSuccess(v);
                } else if (SingleFromObservable.this.defaultValue != null) {
                    s.onSuccess(SingleFromObservable.this.defaultValue);
                } else {
                    s.onError(new NoSuchElementException());
                }
            }
        });
    }
}

