/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class TrampolineScheduler
extends Scheduler {
    private static final TrampolineScheduler INSTANCE = new TrampolineScheduler();

    public static TrampolineScheduler instance() {
        return INSTANCE;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new TrampolineWorker();
    }

    TrampolineScheduler() {
    }

    @Override
    public Disposable scheduleDirect(Runnable run) {
        run.run();
        return EmptyDisposable.INSTANCE;
    }

    @Override
    public Disposable scheduleDirect(Runnable run, long delay, TimeUnit unit) {
        try {
            unit.sleep(delay);
            run.run();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            RxJavaPlugins.onError(ex);
        }
        return EmptyDisposable.INSTANCE;
    }

    static final class SleepingRunnable
    implements Runnable {
        private final Runnable run;
        private final TrampolineWorker worker;
        private final long execTime;

        SleepingRunnable(Runnable run, TrampolineWorker worker, long execTime) {
            this.run = run;
            this.worker = worker;
            this.execTime = execTime;
        }

        @Override
        public void run() {
            long delay;
            if (this.worker.disposed) {
                return;
            }
            long t = this.worker.now(TimeUnit.MILLISECONDS);
            if (this.execTime > t && (delay = this.execTime - t) > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    RxJavaPlugins.onError(e);
                    return;
                }
            }
            if (this.worker.disposed) {
                return;
            }
            this.run.run();
        }
    }

    static final class TimedRunnable
    implements Comparable<TimedRunnable> {
        final Runnable run;
        final long execTime;
        final int count;
        volatile boolean disposed;

        TimedRunnable(Runnable run, Long execTime, int count) {
            this.run = run;
            this.execTime = execTime;
            this.count = count;
        }

        @Override
        public int compareTo(TimedRunnable that) {
            int result = ObjectHelper.compare(this.execTime, that.execTime);
            if (result == 0) {
                return ObjectHelper.compare(this.count, that.count);
            }
            return result;
        }
    }

    static final class TrampolineWorker
    extends Scheduler.Worker
    implements Disposable {
        final PriorityBlockingQueue<TimedRunnable> queue = new PriorityBlockingQueue();
        private final AtomicInteger wip = new AtomicInteger();
        final AtomicInteger counter = new AtomicInteger();
        volatile boolean disposed;

        TrampolineWorker() {
        }

        @Override
        public Disposable schedule(Runnable action) {
            return this.enqueue(action, this.now(TimeUnit.MILLISECONDS));
        }

        @Override
        public Disposable schedule(Runnable action, long delayTime, TimeUnit unit) {
            long execTime = this.now(TimeUnit.MILLISECONDS) + unit.toMillis(delayTime);
            return this.enqueue(new SleepingRunnable(action, this, execTime), execTime);
        }

        Disposable enqueue(Runnable action, long execTime) {
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            final TimedRunnable timedRunnable = new TimedRunnable(action, execTime, this.counter.incrementAndGet());
            this.queue.add(timedRunnable);
            if (this.wip.getAndIncrement() == 0) {
                int missed = 1;
                while (true) {
                    TimedRunnable polled;
                    if ((polled = this.queue.poll()) != null) {
                        if (polled.disposed) continue;
                        polled.run.run();
                        continue;
                    }
                    if ((missed = this.wip.addAndGet(-missed)) == 0) break;
                }
                return EmptyDisposable.INSTANCE;
            }
            return Disposables.fromRunnable(new Runnable(){

                @Override
                public void run() {
                    timedRunnable.disposed = true;
                    TrampolineWorker.this.queue.remove(timedRunnable);
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

