/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.observables;

import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.operators.observable.ObservableAutoConnect;
import io.reactivex.internal.operators.observable.ObservableRefCount;
import io.reactivex.plugins.RxJavaPlugins;

public abstract class ConnectableObservable<T>
extends Observable<T> {
    public abstract void connect(Consumer<? super Disposable> var1);

    public final Disposable connect() {
        final Disposable[] connection = new Disposable[1];
        this.connect((Consumer<Disposable>)new Consumer<Disposable>(){

            @Override
            public void accept(Disposable d) {
                connection[0] = d;
            }
        });
        return connection[0];
    }

    public Observable<T> refCount() {
        return RxJavaPlugins.onAssembly(new ObservableRefCount(this));
    }

    public Observable<T> autoConnect() {
        return this.autoConnect(1);
    }

    public Observable<T> autoConnect(int numberOfSubscribers) {
        return this.autoConnect(numberOfSubscribers, Functions.emptyConsumer());
    }

    public Observable<T> autoConnect(int numberOfSubscribers, Consumer<? super Disposable> connection) {
        if (numberOfSubscribers <= 0) {
            this.connect(connection);
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new ObservableAutoConnect(this, numberOfSubscribers, connection));
    }
}

