/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableSubscribeOn
extends Completable {
    final CompletableSource source;
    final Scheduler scheduler;

    public CompletableSubscribeOn(CompletableSource source, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(CompletableObserver s) {
        final SubscribeOnObserver parent = new SubscribeOnObserver(s);
        s.onSubscribe(parent);
        Disposable f = this.scheduler.scheduleDirect(new Runnable(){

            @Override
            public void run() {
                CompletableSubscribeOn.this.source.subscribe(parent);
            }
        });
        parent.task.replace(f);
    }

    static final class SubscribeOnObserver
    extends AtomicReference<Disposable>
    implements CompletableObserver,
    Disposable {
        private static final long serialVersionUID = 7000911171163930287L;
        final CompletableObserver actual;
        final SequentialDisposable task;

        SubscribeOnObserver(CompletableObserver actual) {
            this.actual = actual;
            this.task = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            this.task.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this);
        }
    }
}

