/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableScanSeed<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final BiFunction<R, ? super T, R> accumulator;
    final Callable<R> seedSupplier;

    public FlowableScanSeed(Publisher<T> source, Callable<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.accumulator = accumulator;
        this.seedSupplier = seedSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        R r;
        try {
            r = ObjectHelper.requireNonNull(this.seedSupplier.call(), "The seed supplied is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, s);
            return;
        }
        this.source.subscribe(new ScanSeedSubscriber<T, R>(s, this.accumulator, r));
    }

    static final class ScanSeedSubscriber<T, R>
    extends QueueDrainSubscriber<T, R, R>
    implements Subscription {
        final BiFunction<R, ? super T, R> accumulator;
        R value;
        Subscription s;

        ScanSeedSubscriber(Subscriber<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value) {
            super(actual, new SpscArrayQueue(2));
            this.accumulator = accumulator;
            this.value = value;
            this.queue.offer(value);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            R u;
            R v = this.value;
            try {
                u = ObjectHelper.requireNonNull(this.accumulator.apply(v, t), "The accumulator returned a null value");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.cancel();
                this.onError(e);
                return;
            }
            this.value = u;
            if (!this.queue.offer(u)) {
                this.s.cancel();
                this.onError(new IllegalStateException("Queue if full?!"));
                return;
            }
            this.drain(false);
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain(false);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain(false);
        }

        public void request(long n) {
            this.requested(n);
            this.s.request(n);
            this.drain(false);
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
            }
        }

        @Override
        public boolean accept(Subscriber<? super R> a, R v) {
            a.onNext(v);
            return true;
        }
    }
}

