/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.observers.SerializedObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableBufferTimed<T, U extends Collection<? super T>>
extends AbstractObservableWithUpstream<T, U> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Callable<U> bufferSupplier;
    final int maxSize;
    final boolean restartTimerOnMaxSize;

    public ObservableBufferTimed(ObservableSource<T> source, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, Callable<U> bufferSupplier, int maxSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSupplier = bufferSupplier;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t) {
        if (this.timespan == this.timeskip && this.maxSize == Integer.MAX_VALUE) {
            this.source.subscribe(new BufferExactUnboundedObserver(new SerializedObserver<U>(t), this.bufferSupplier, this.timespan, this.unit, this.scheduler));
            return;
        }
        Scheduler.Worker w = this.scheduler.createWorker();
        if (this.timespan == this.timeskip) {
            this.source.subscribe(new BufferExactBoundedObserver(new SerializedObserver<U>(t), this.bufferSupplier, this.timespan, this.unit, this.maxSize, this.restartTimerOnMaxSize, w));
            return;
        }
        this.source.subscribe(new BufferSkipBoundedObserver(new SerializedObserver<U>(t), this.bufferSupplier, this.timespan, this.timeskip, this.unit, w));
    }

    static final class BufferExactBoundedObserver<T, U extends Collection<? super T>>
    extends QueueDrainObserver<T, U, U>
    implements Runnable,
    Disposable {
        final Callable<U> bufferSupplier;
        final long timespan;
        final TimeUnit unit;
        final int maxSize;
        final boolean restartTimerOnMaxSize;
        final Scheduler.Worker w;
        U buffer;
        Disposable timer;
        Disposable s;
        long producerIndex;
        long consumerIndex;

        BufferExactBoundedObserver(Observer<? super U> actual, Callable<U> bufferSupplier, long timespan, TimeUnit unit, int maxSize, boolean restartOnMaxSize, Scheduler.Worker w) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.unit = unit;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartOnMaxSize;
            this.w = w;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                Collection b;
                this.s = s;
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    s.dispose();
                    EmptyDisposable.error(e, this.actual);
                    this.w.dispose();
                    return;
                }
                this.buffer = b;
                this.actual.onSubscribe(this);
                this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            Object b;
            BufferExactBoundedObserver bufferExactBoundedObserver = this;
            synchronized (bufferExactBoundedObserver) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
                if (b.size() < this.maxSize) {
                    return;
                }
            }
            if (this.restartTimerOnMaxSize) {
                this.buffer = null;
                ++this.producerIndex;
                this.timer.dispose();
            }
            this.fastPathOrderedEmit(b, false, this);
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                this.dispose();
                return;
            }
            if (this.restartTimerOnMaxSize) {
                bufferExactBoundedObserver = this;
                synchronized (bufferExactBoundedObserver) {
                    this.buffer = b;
                    ++this.consumerIndex;
                }
                this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
            } else {
                bufferExactBoundedObserver = this;
                synchronized (bufferExactBoundedObserver) {
                    this.buffer = b;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            BufferExactBoundedObserver bufferExactBoundedObserver = this;
            synchronized (bufferExactBoundedObserver) {
                this.buffer = null;
            }
            this.actual.onError(t);
            this.w.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            this.w.dispose();
            BufferExactBoundedObserver bufferExactBoundedObserver = this;
            synchronized (bufferExactBoundedObserver) {
                b = this.buffer;
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(this.queue, this.actual, false, this, this);
            }
        }

        @Override
        public void accept(Observer<? super U> a, U v) {
            a.onNext(v);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.dispose();
                this.w.dispose();
                BufferExactBoundedObserver bufferExactBoundedObserver = this;
                synchronized (bufferExactBoundedObserver) {
                    this.buffer = null;
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            U current;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.dispose();
                this.actual.onError(e);
                return;
            }
            BufferExactBoundedObserver bufferExactBoundedObserver = this;
            synchronized (bufferExactBoundedObserver) {
                current = this.buffer;
                if (current == null || this.producerIndex != this.consumerIndex) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathOrderedEmit(current, false, this);
        }
    }

    static final class BufferSkipBoundedObserver<T, U extends Collection<? super T>>
    extends QueueDrainObserver<T, U, U>
    implements Runnable,
    Disposable {
        final Callable<U> bufferSupplier;
        final long timespan;
        final long timeskip;
        final TimeUnit unit;
        final Scheduler.Worker w;
        final List<U> buffers;
        Disposable s;

        BufferSkipBoundedObserver(Observer<? super U> actual, Callable<U> bufferSupplier, long timespan, long timeskip, TimeUnit unit, Scheduler.Worker w) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.timeskip = timeskip;
            this.unit = unit;
            this.w = w;
            this.buffers = new LinkedList<U>();
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                Collection b;
                this.s = s;
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    s.dispose();
                    EmptyDisposable.error(e, this.actual);
                    this.w.dispose();
                    return;
                }
                this.buffers.add(b);
                this.actual.onSubscribe(this);
                this.w.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
                this.w.schedule(new RemoveFromBufferEmit(this, b), this.timespan, this.unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferSkipBoundedObserver bufferSkipBoundedObserver = this;
            synchronized (bufferSkipBoundedObserver) {
                for (Collection b : this.buffers) {
                    b.add(t);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            this.done = true;
            this.clear();
            this.actual.onError(t);
            this.w.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            ArrayList<U> bs;
            BufferSkipBoundedObserver bufferSkipBoundedObserver = this;
            synchronized (bufferSkipBoundedObserver) {
                bs = new ArrayList<U>(this.buffers);
                this.buffers.clear();
            }
            for (Collection b : bs) {
                this.queue.offer(b);
            }
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(this.queue, this.actual, false, this.w, this);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.clear();
                this.s.dispose();
                this.w.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            BufferSkipBoundedObserver bufferSkipBoundedObserver = this;
            synchronized (bufferSkipBoundedObserver) {
                this.buffers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Collection b;
            if (this.cancelled) {
                return;
            }
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                this.dispose();
                return;
            }
            BufferSkipBoundedObserver bufferSkipBoundedObserver = this;
            synchronized (bufferSkipBoundedObserver) {
                if (this.cancelled) {
                    return;
                }
                this.buffers.add(b);
            }
            this.w.schedule(new RemoveFromBuffer(this, b), this.timespan, this.unit);
        }

        @Override
        public void accept(Observer<? super U> a, U v) {
            a.onNext(v);
        }

        static final class RemoveFromBufferEmit
        implements Runnable {
            private final U buffer;
            final /* synthetic */ BufferSkipBoundedObserver this$0;

            RemoveFromBufferEmit(U buffer) {
                this.this$0 = var1_1;
                this.buffer = buffer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferSkipBoundedObserver bufferSkipBoundedObserver = this.this$0;
                synchronized (bufferSkipBoundedObserver) {
                    this.this$0.buffers.remove(this.buffer);
                }
                this.this$0.fastPathOrderedEmit(this.buffer, false, this.this$0.w);
            }
        }

        static final class RemoveFromBuffer
        implements Runnable {
            private final U b;
            final /* synthetic */ BufferSkipBoundedObserver this$0;

            RemoveFromBuffer(U b) {
                this.this$0 = var1_1;
                this.b = b;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferSkipBoundedObserver bufferSkipBoundedObserver = this.this$0;
                synchronized (bufferSkipBoundedObserver) {
                    this.this$0.buffers.remove(this.b);
                }
                this.this$0.fastPathOrderedEmit(this.b, false, this.this$0.w);
            }
        }
    }

    static final class BufferExactUnboundedObserver<T, U extends Collection<? super T>>
    extends QueueDrainObserver<T, U, U>
    implements Runnable,
    Disposable {
        final Callable<U> bufferSupplier;
        final long timespan;
        final TimeUnit unit;
        final Scheduler scheduler;
        Disposable s;
        U buffer;
        final AtomicReference<Disposable> timer = new AtomicReference();

        BufferExactUnboundedObserver(Observer<? super U> actual, Callable<U> bufferSupplier, long timespan, TimeUnit unit, Scheduler scheduler) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                Disposable d;
                Collection b;
                this.s = s;
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.dispose();
                    EmptyDisposable.error(e, this.actual);
                    return;
                }
                this.buffer = b;
                this.actual.onSubscribe(this);
                if (!this.cancelled && !this.timer.compareAndSet(null, d = this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit))) {
                    d.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferExactUnboundedObserver bufferExactUnboundedObserver = this;
            synchronized (bufferExactUnboundedObserver) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            BufferExactUnboundedObserver bufferExactUnboundedObserver = this;
            synchronized (bufferExactUnboundedObserver) {
                this.buffer = null;
            }
            this.actual.onError(t);
            DisposableHelper.dispose(this.timer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferExactUnboundedObserver bufferExactUnboundedObserver = this;
            synchronized (bufferExactUnboundedObserver) {
                b = this.buffer;
                this.buffer = null;
            }
            if (b != null) {
                this.queue.offer(b);
                this.done = true;
                if (this.enter()) {
                    QueueDrainHelper.drainLoop(this.queue, this.actual, false, this, this);
                }
            }
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.timer);
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.timer.get() == DisposableHelper.DISPOSED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            U current;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                this.dispose();
                return;
            }
            BufferExactUnboundedObserver bufferExactUnboundedObserver = this;
            synchronized (bufferExactUnboundedObserver) {
                current = this.buffer;
                if (current != null) {
                    this.buffer = next;
                }
            }
            if (current == null) {
                DisposableHelper.dispose(this.timer);
                return;
            }
            this.fastPathEmit(current, false, this);
        }

        @Override
        public void accept(Observer<? super U> a, U v) {
            this.actual.onNext(v);
        }
    }
}

