/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjavafx.observables;

import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.rxjavafx.sources.ActionEventSource;
import io.reactivex.rxjavafx.sources.Change;
import io.reactivex.rxjavafx.sources.DialogSource;
import io.reactivex.rxjavafx.sources.ListChange;
import io.reactivex.rxjavafx.sources.MapChange;
import io.reactivex.rxjavafx.sources.NodeEventSource;
import io.reactivex.rxjavafx.sources.ObservableListSource;
import io.reactivex.rxjavafx.sources.ObservableMapSource;
import io.reactivex.rxjavafx.sources.ObservableSetSource;
import io.reactivex.rxjavafx.sources.ObservableValueSource;
import io.reactivex.rxjavafx.sources.SceneEventSource;
import io.reactivex.rxjavafx.sources.SetChange;
import io.reactivex.rxjavafx.sources.TimerSource;
import io.reactivex.rxjavafx.sources.WindowEventSource;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.MenuItem;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;

public enum JavaFxObservable {


    public static <T extends Event> Observable<T> eventsOf(Node node, EventType<T> eventType) {
        return NodeEventSource.fromNodeEvents(node, eventType);
    }

    public static <T> Observable<T> valuesOf(ObservableValue<T> fxObservable) {
        return ObservableValueSource.fromObservableValue(fxObservable);
    }

    public static <T> Observable<T> valuesOf(ObservableValue<T> fxObservable, T nullSentinel) {
        return ObservableValueSource.fromObservableValue(fxObservable, nullSentinel);
    }

    public static <T> Observable<Optional<T>> nullableValuesOf(ObservableValue<T> fxObservable) {
        return ObservableValueSource.fromNullableObservableValue(fxObservable);
    }

    public static <T> Observable<Change<T>> changesOf(ObservableValue<T> fxObservable) {
        return ObservableValueSource.fromObservableValueChanges(fxObservable);
    }

    public static <T> Observable<Change<T>> nonNullChangesOf(ObservableValue<T> fxObservable) {
        return JavaFxObservable.changesOf(fxObservable).filter(t -> t.getOldVal() != null && t.getNewVal() != null);
    }

    public static Observable<javafx.beans.Observable> invalidationsOf(javafx.beans.Observable fxObservable) {
        return ObservableValueSource.fromInvalidations(fxObservable);
    }

    public static <T extends Event> Observable<T> eventsOf(Scene scene, EventType<T> eventType) {
        return SceneEventSource.fromSceneEvents(scene, eventType);
    }

    public static <T extends WindowEvent> Observable<T> eventsOf(Window window, EventType<T> eventType) {
        return WindowEventSource.fromWindowEvents(window, eventType);
    }

    public static Observable<ActionEvent> actionEventsOf(Node node) {
        return ActionEventSource.fromActionEvents(node);
    }

    public static Observable<ActionEvent> actionEventsOf(ContextMenu contextMenu) {
        return ActionEventSource.fromActionEvents(contextMenu);
    }

    public static Observable<ActionEvent> actionEventsOf(MenuItem menuItem) {
        return ActionEventSource.fromActionEvents(menuItem);
    }

    public static <T> Observable<ObservableList<T>> emitOnChanged(ObservableList<T> source) {
        return ObservableListSource.fromObservableList(source);
    }

    public static <T> Observable<T> additionsOf(ObservableList<T> source) {
        return ObservableListSource.fromObservableListAdds(source);
    }

    public static <T> Observable<T> removalsOf(ObservableList<T> source) {
        return ObservableListSource.fromObservableListRemovals(source);
    }

    public static <T> Observable<T> updatesOf(ObservableList<T> source) {
        return ObservableListSource.fromObservableListUpdates(source);
    }

    public static <T> Observable<ListChange<T>> changesOf(ObservableList<T> source) {
        return ObservableListSource.fromObservableListChanges(source);
    }

    public static <T> Observable<ListChange<T>> distinctChangesOf(ObservableList<T> source) {
        return ObservableListSource.fromObservableListDistinctChanges(source);
    }

    public static <T, R> Observable<ListChange<T>> distinctChangesOf(ObservableList<T> source, Function<T, R> mapper) {
        return ObservableListSource.fromObservableListDistinctChanges(source, mapper);
    }

    public static <T, R> Observable<ListChange<R>> distinctMappingsOf(ObservableList<T> source, Function<T, R> mapper) {
        return ObservableListSource.fromObservableListDistinctMappings(source, mapper);
    }

    public static <K, T> Observable<ObservableMap<K, T>> emitOnChanged(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMap(source);
    }

    public static <K, T> Observable<Map.Entry<K, T>> additionsOf(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMapAdds(source);
    }

    public static <K, T> Observable<Map.Entry<K, T>> removalsOf(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMapRemovals(source);
    }

    public static <K, T> Observable<MapChange<K, T>> changesOf(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMapChanges(source);
    }

    public static <T> Observable<ObservableSet<T>> emitOnChanged(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSet(source);
    }

    public static <T> Observable<T> additionsOf(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSetAdds(source);
    }

    public static <T> Observable<T> removalsOf(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSetRemovals(source);
    }

    public static <T> Observable<SetChange<T>> changesOf(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSetChanges(source);
    }

    public static Observable<Long> interval(Duration duration) {
        return TimerSource.interval(duration);
    }

    public static <T> Maybe<T> fromDialog(Dialog<T> dialog) {
        return DialogSource.fromDialogSource(dialog);
    }
}

